/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.options;

import io.greptime.common.Copiable;
import io.greptime.common.Endpoint;
import io.greptime.common.util.Ensures;
import io.greptime.limit.LimitedPolicy;
import io.greptime.models.AuthInfo;
import io.greptime.options.QueryOptions;
import io.greptime.options.RouterOptions;
import io.greptime.options.WriteOptions;
import io.greptime.rpc.RpcOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;

public class GreptimeOptions
implements Copiable<GreptimeOptions> {
    private List<Endpoint> endpoints;
    private Executor asyncWritePool;
    private Executor asyncReadPool;
    private RpcOptions rpcOptions;
    private RouterOptions routerOptions;
    private WriteOptions writeOptions;
    private QueryOptions queryOptions;
    private AuthInfo authInfo;

    public List<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    public Executor getAsyncWritePool() {
        return this.asyncWritePool;
    }

    public void setAsyncWritePool(Executor asyncWritePool) {
        this.asyncWritePool = asyncWritePool;
    }

    public Executor getAsyncReadPool() {
        return this.asyncReadPool;
    }

    public void setAsyncReadPool(Executor asyncReadPool) {
        this.asyncReadPool = asyncReadPool;
    }

    public RpcOptions getRpcOptions() {
        return this.rpcOptions;
    }

    public void setRpcOptions(RpcOptions rpcOptions) {
        this.rpcOptions = rpcOptions;
    }

    public RouterOptions getRouterOptions() {
        return this.routerOptions;
    }

    public void setRouterOptions(RouterOptions routerOptions) {
        this.routerOptions = routerOptions;
    }

    public WriteOptions getWriteOptions() {
        return this.writeOptions;
    }

    public void setWriteOptions(WriteOptions writeOptions) {
        this.writeOptions = writeOptions;
    }

    public QueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    public void setQueryOptions(QueryOptions queryOptions) {
        this.queryOptions = queryOptions;
    }

    public AuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public void setAuthInfo(AuthInfo authInfo) {
        this.authInfo = authInfo;
    }

    public GreptimeOptions copy() {
        GreptimeOptions opts = new GreptimeOptions();
        opts.endpoints = new ArrayList<Endpoint>(this.endpoints);
        opts.asyncWritePool = this.asyncWritePool;
        opts.asyncReadPool = this.asyncReadPool;
        opts.authInfo = this.authInfo;
        if (this.rpcOptions != null) {
            opts.rpcOptions = this.rpcOptions.copy();
        }
        if (this.routerOptions != null) {
            opts.routerOptions = this.routerOptions.copy();
        }
        if (this.writeOptions != null) {
            opts.writeOptions = this.writeOptions.copy();
        }
        if (this.queryOptions != null) {
            opts.queryOptions = this.queryOptions.copy();
        }
        return opts;
    }

    public String toString() {
        return "GreptimeOptions{endpoints=" + this.endpoints + ", asyncWritePool=" + this.asyncWritePool + ", asyncReadPool=" + this.asyncReadPool + ", rpcOptions=" + this.rpcOptions + ", routerOptions=" + this.routerOptions + ", writeOptions=" + this.writeOptions + ", queryOptions=" + this.queryOptions + ", authInfo=" + this.authInfo + '}';
    }

    public static GreptimeOptions checkSelf(GreptimeOptions opts) {
        Ensures.ensureNonNull((Object)opts, (String)"null `opts (GreptimeOptions)`)`");
        Ensures.ensureNonNull(opts.getEndpoints(), (String)"null `endpoints`");
        Ensures.ensure((!opts.getEndpoints().isEmpty() ? 1 : 0) != 0, (Object)"empty `endpoints`");
        Ensures.ensureNonNull((Object)opts.getRpcOptions(), (String)"null `rpcOptions`");
        Ensures.ensureNonNull((Object)opts.getRouterOptions(), (String)"null `routerOptions`");
        Ensures.ensureNonNull((Object)opts.getWriteOptions(), (String)"null `writeOptions`");
        Ensures.ensureNonNull((Object)opts.getQueryOptions(), (String)"null `queryOptions`");
        return opts;
    }

    public static Builder newBuilder(List<Endpoint> endpoints) {
        return new Builder(endpoints);
    }

    public static Builder newBuilder(Endpoint ... endpoints) {
        return new Builder(Arrays.stream(endpoints).collect(Collectors.toList()));
    }

    public static Builder newBuilder(String ... endpoints) {
        return new Builder(Arrays.stream(endpoints).map(Endpoint::parse).collect(Collectors.toList()));
    }

    public static final class Builder {
        private final List<Endpoint> endpoints = new ArrayList<Endpoint>();
        private Executor asyncWritePool;
        private Executor asyncReadPool;
        private RpcOptions rpcOptions = RpcOptions.newDefault();
        private int writeMaxRetries = 1;
        private int maxInFlightWriteRows = 65536;
        private LimitedPolicy writeLimitedPolicy = LimitedPolicy.defaultWriteLimitedPolicy();
        private int defaultStreamMaxWritePointsPerSecond = 655360;
        private int readMaxRetries = 1;
        private long routeTableRefreshPeriodSeconds = 30L;
        private AuthInfo authInfo;

        public Builder(List<Endpoint> endpoints) {
            this.endpoints.addAll(endpoints);
        }

        public Builder asyncPool(Executor asyncWritePool, Executor asyncReadPool) {
            this.asyncWritePool = asyncWritePool;
            this.asyncReadPool = asyncReadPool;
            return this;
        }

        public Builder rpcOptions(RpcOptions rpcOptions) {
            this.rpcOptions = rpcOptions;
            return this;
        }

        public Builder writeMaxRetries(int maxRetries) {
            this.writeMaxRetries = maxRetries;
            return this;
        }

        public Builder maxInFlightWriteRows(int maxInFlightWriteRows) {
            this.maxInFlightWriteRows = maxInFlightWriteRows;
            return this;
        }

        public Builder writeLimitedPolicy(LimitedPolicy writeLimitedPolicy) {
            this.writeLimitedPolicy = writeLimitedPolicy;
            return this;
        }

        public Builder defaultStreamMaxWritePointsPerSecond(int defaultStreamMaxWritePointsPerSecond) {
            this.defaultStreamMaxWritePointsPerSecond = defaultStreamMaxWritePointsPerSecond;
            return this;
        }

        public Builder readMaxRetries(int maxRetries) {
            this.readMaxRetries = maxRetries;
            return this;
        }

        public Builder routeTableRefreshPeriodSeconds(long routeTableRefreshPeriodSeconds) {
            this.routeTableRefreshPeriodSeconds = routeTableRefreshPeriodSeconds;
            return this;
        }

        public Builder authInfo(AuthInfo authInfo) {
            this.authInfo = authInfo;
            return this;
        }

        public GreptimeOptions build() {
            GreptimeOptions opts = new GreptimeOptions();
            opts.setEndpoints(this.endpoints);
            opts.setAsyncWritePool(this.asyncWritePool);
            opts.setAsyncReadPool(this.asyncReadPool);
            opts.setRpcOptions(this.rpcOptions);
            opts.setAuthInfo(this.authInfo);
            RouterOptions routerOpts = new RouterOptions();
            routerOpts.setEndpoints(this.endpoints);
            routerOpts.setRefreshPeriodSeconds(this.routeTableRefreshPeriodSeconds);
            opts.setRouterOptions(routerOpts);
            WriteOptions writeOpts = new WriteOptions();
            writeOpts.setAsyncPool(this.asyncWritePool);
            writeOpts.setMaxRetries(this.writeMaxRetries);
            writeOpts.setMaxInFlightWriteRows(this.maxInFlightWriteRows);
            writeOpts.setLimitedPolicy(this.writeLimitedPolicy);
            writeOpts.setDefaultStreamMaxWritePointsPerSecond(this.defaultStreamMaxWritePointsPerSecond);
            opts.setWriteOptions(writeOpts);
            QueryOptions queryOpts = new QueryOptions();
            queryOpts.setAsyncPool(this.asyncReadPool);
            queryOpts.setMaxRetries(this.readMaxRetries);
            opts.setQueryOptions(queryOpts);
            return GreptimeOptions.checkSelf(opts);
        }
    }
}

