/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.models;

import io.greptime.common.util.Ensures;
import io.greptime.models.AuthInfo;
import io.greptime.models.TableName;
import io.greptime.models.WriteRows;
import io.greptime.v1.Common;
import io.greptime.v1.Database;
import java.util.Collection;
import java.util.Collections;

public class WriteRowsHelper {
    public static Database.GreptimeRequest toGreptimeRequest(WriteRows rows, AuthInfo authInfo) {
        return WriteRowsHelper.toGreptimeRequest(Collections.singleton(rows.tableName()), Collections.singleton(rows), authInfo);
    }

    public static Database.GreptimeRequest toGreptimeRequest(Collection<TableName> tableNames, Collection<WriteRows> rows, AuthInfo authInfo) {
        String dbName = null;
        for (TableName t : tableNames) {
            if (dbName == null) {
                dbName = t.getDatabaseName();
                continue;
            }
            if (dbName.equals(t.getDatabaseName())) continue;
            String errMsg = String.format("Write to multiple databases is not supported: %s, %s", dbName, t.getDatabaseName());
            throw new IllegalArgumentException(errMsg);
        }
        Common.RequestHeader.Builder headerBuilder = Common.RequestHeader.newBuilder();
        if (dbName != null) {
            headerBuilder.setDbname(dbName);
        }
        if (authInfo != null) {
            headerBuilder.setAuthorization(authInfo.into());
        }
        Database.InsertRequests.Builder insertRequestsBuilder = Database.InsertRequests.newBuilder();
        Database.RowInsertRequests.Builder rowInsertRequestsBuilder = Database.RowInsertRequests.newBuilder();
        for (WriteRows r : rows) {
            switch (r.writeProtocol()) {
                case Columnar: {
                    insertRequestsBuilder.addInserts(r.intoColumnarInsertRequest());
                    break;
                }
                case Row: {
                    rowInsertRequestsBuilder.addInserts(r.intoRowInsertRequest());
                }
            }
        }
        if (insertRequestsBuilder.getInsertsCount() > 0) {
            Ensures.ensure((rowInsertRequestsBuilder.getInsertsCount() == 0 ? 1 : 0) != 0, (Object)"Columnar and Row inserts cannot be mixed");
            return Database.GreptimeRequest.newBuilder().setHeader(headerBuilder.build()).setInserts(insertRequestsBuilder.build()).build();
        }
        if (rowInsertRequestsBuilder.getInsertsCount() > 0) {
            Ensures.ensure((insertRequestsBuilder.getInsertsCount() == 0 ? 1 : 0) != 0, (Object)"Columnar and Row inserts cannot be mixed");
            return Database.GreptimeRequest.newBuilder().setHeader(headerBuilder.build()).setRowInserts(rowInsertRequestsBuilder.build()).build();
        }
        throw new IllegalArgumentException("No inserts");
    }

    private WriteRowsHelper() {
    }
}

