/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.models;

import com.google.protobuf.ByteStringHelper;
import io.greptime.common.Into;
import io.greptime.common.util.Ensures;
import io.greptime.models.ColumnHelper;
import io.greptime.models.RowHelper;
import io.greptime.models.TableName;
import io.greptime.models.TableSchema;
import io.greptime.v1.Columns;
import io.greptime.v1.Common;
import io.greptime.v1.Database;
import io.greptime.v1.RowData;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.stream.Collectors;

public interface WriteRows {
    public WriteProtocol writeProtocol();

    public TableName tableName();

    public int rowCount();

    public int columnCount();

    default public int pointCount() {
        return this.rowCount() * this.columnCount();
    }

    public WriteRows insert(Object ... var1);

    public void finish();

    public Database.InsertRequest intoColumnarInsertRequest();

    public Database.RowInsertRequest intoRowInsertRequest();

    default public void checkNumValues(int len) {
        int columnCount = this.columnCount();
        Ensures.ensure((columnCount == len ? 1 : 0) != 0, (String)"Expected values num: %d, actual: %d", (Object[])new Object[]{columnCount, len});
    }

    public static Builder newBuilder(TableSchema tableSchema) {
        return WriteRows.newRowBasedBuilder(tableSchema);
    }

    public static Builder newColumnarBasedBuilder(TableSchema tableSchema) {
        return new Builder(WriteProtocol.Columnar, tableSchema);
    }

    public static Builder newRowBasedBuilder(TableSchema tableSchema) {
        return new Builder(WriteProtocol.Row, tableSchema);
    }

    public static class RowBasedWriteRows
    implements WriteRows,
    Into<Database.RowInsertRequest> {
        private TableName tableName;
        private List<RowData.ColumnSchema> columnSchemas;
        private final List<RowData.Row> rows = new ArrayList<RowData.Row>();

        @Override
        public WriteProtocol writeProtocol() {
            return WriteProtocol.Row;
        }

        @Override
        public TableName tableName() {
            return this.tableName;
        }

        @Override
        public int rowCount() {
            return this.rows.size();
        }

        @Override
        public int columnCount() {
            return this.columnSchemas.size();
        }

        @Override
        public WriteRows insert(Object ... values) {
            this.checkNumValues(values.length);
            RowData.Row.Builder rowBuilder = RowData.Row.newBuilder();
            for (int i = 0; i < values.length; ++i) {
                RowData.ColumnSchema columnSchema = this.columnSchemas.get(i);
                Object value = values[i];
                RowHelper.addValue(rowBuilder, columnSchema.getDatatype(), value);
            }
            this.rows.add(rowBuilder.build());
            return this;
        }

        @Override
        public void finish() {
        }

        @Override
        public Database.InsertRequest intoColumnarInsertRequest() {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public Database.RowInsertRequest intoRowInsertRequest() {
            return this.into();
        }

        public Database.RowInsertRequest into() {
            TableName tableName = this.tableName();
            RowData.Rows rows = RowData.Rows.newBuilder().addAllSchema(this.columnSchemas).addAllRows(this.rows).build();
            return Database.RowInsertRequest.newBuilder().setTableName(tableName.getTableName()).setRows(rows).build();
        }

        List<RowData.ColumnSchema> columnSchemas() {
            return this.columnSchemas;
        }

        List<RowData.Row> rows() {
            return this.rows;
        }
    }

    public static class ColumnarBasedWriteRows
    implements WriteRows,
    Into<Database.InsertRequest> {
        private TableName tableName;
        private int columnCount;
        private List<Columns.Column.Builder> builders;
        private BitSet[] nullMasks;
        private List<Columns.Column> columns;
        private int rowCount;

        @Override
        public WriteProtocol writeProtocol() {
            return WriteProtocol.Columnar;
        }

        @Override
        public TableName tableName() {
            return this.tableName;
        }

        @Override
        public int rowCount() {
            return this.rowCount;
        }

        @Override
        public int columnCount() {
            return this.columnCount;
        }

        @Override
        public WriteRows insert(Object ... values) {
            this.checkNumValues(values.length);
            for (int i = 0; i < this.columnCount; ++i) {
                Columns.Column.Builder builder = this.builders.get(i);
                Object value = values[i];
                if (value == null) {
                    if (this.nullMasks[i] == null) {
                        this.nullMasks[i] = new BitSet();
                    }
                    this.nullMasks[i].set(this.rowCount);
                    continue;
                }
                ColumnHelper.addToColumnValuesBuilder(builder, value);
            }
            ++this.rowCount;
            return this;
        }

        @Override
        public void finish() {
            if (this.columns != null) {
                return;
            }
            for (int i = 0; i < this.columnCount; ++i) {
                BitSet bits = this.nullMasks[i];
                if (bits == null) continue;
                byte[] bytes = bits.toByteArray();
                this.builders.get(i).setNullMask(ByteStringHelper.wrap((byte[])bytes));
            }
            this.columns = this.builders.stream().map(Columns.Column.Builder::build).collect(Collectors.toList());
        }

        @Override
        public Database.InsertRequest intoColumnarInsertRequest() {
            return this.into();
        }

        @Override
        public Database.RowInsertRequest intoRowInsertRequest() {
            throw new UnsupportedOperationException("Not supported");
        }

        public Database.InsertRequest into() {
            TableName tableName = this.tableName();
            int rowCount = this.rowCount();
            Ensures.ensure((rowCount > 0 ? 1 : 0) != 0, (Object)"`WriteRows` must contain at least one row of data");
            Ensures.ensureNonNull(this.columns, (String)"Forget to call `WriteRows.finish()`?");
            return Database.InsertRequest.newBuilder().setTableName(tableName.getTableName()).addAllColumns(this.columns).setRowCount(rowCount).build();
        }

        List<Columns.Column> columns() {
            return this.columns;
        }

        static /* synthetic */ BitSet[] access$302(ColumnarBasedWriteRows x0, BitSet[] x1) {
            x0.nullMasks = x1;
            return x1;
        }
    }

    public static class Builder {
        private final WriteProtocol writeProtocol;
        private final TableSchema tableSchema;

        public Builder(WriteProtocol writeProtocol, TableSchema tableSchema) {
            this.writeProtocol = writeProtocol;
            this.tableSchema = tableSchema;
        }

        public WriteRows build() {
            TableName tableName = this.tableSchema.getTableName();
            List<String> columnNames = this.tableSchema.getColumnNames();
            List<Common.SemanticType> semanticTypes = this.tableSchema.getSemanticTypes();
            List<Common.ColumnDataType> dataTypes = this.tableSchema.getDataTypes();
            Ensures.ensureNonNull((Object)tableName, (String)"Null table name");
            Ensures.ensureNonNull(columnNames, (String)"Null column names");
            Ensures.ensureNonNull(semanticTypes, (String)"Null semantic types");
            Ensures.ensureNonNull(dataTypes, (String)"Null data types");
            int columnCount = columnNames.size();
            Ensures.ensure((columnCount > 0 ? 1 : 0) != 0, (Object)"Empty column names");
            Ensures.ensure((columnCount == semanticTypes.size() ? 1 : 0) != 0, (Object)"Column names size not equal to semantic types size");
            Ensures.ensure((columnCount == dataTypes.size() ? 1 : 0) != 0, (Object)"Column names size not equal to data types size");
            switch (this.writeProtocol) {
                case Columnar: {
                    return Builder.buildColumnar(tableName, columnCount, columnNames, semanticTypes, dataTypes);
                }
                case Row: {
                    return Builder.buildRow(tableName, columnCount, columnNames, semanticTypes, dataTypes);
                }
            }
            throw new IllegalStateException("Unknown write protocol: " + (Object)((Object)this.writeProtocol));
        }

        private static WriteRows buildColumnar(TableName tableName, int columnCount, List<String> columnNames, List<Common.SemanticType> semanticTypes, List<Common.ColumnDataType> dataTypes) {
            ColumnarBasedWriteRows rows = new ColumnarBasedWriteRows();
            rows.tableName = tableName;
            rows.columnCount = columnCount;
            rows.builders = new ArrayList();
            for (int i = 0; i < columnCount; ++i) {
                Columns.Column.Builder builder = Columns.Column.newBuilder();
                builder.setColumnName(columnNames.get(i)).setSemanticType(semanticTypes.get(i)).setDatatype(dataTypes.get(i));
                rows.builders.add(builder);
            }
            ColumnarBasedWriteRows.access$302(rows, new BitSet[columnCount]);
            return rows;
        }

        private static WriteRows buildRow(TableName tableName, int columnCount, List<String> columnNames, List<Common.SemanticType> semanticTypes, List<Common.ColumnDataType> dataTypes) {
            RowBasedWriteRows rows = new RowBasedWriteRows();
            rows.tableName = tableName;
            rows.columnSchemas = new ArrayList(columnCount);
            for (int i = 0; i < columnCount; ++i) {
                RowData.ColumnSchema.Builder builder = RowData.ColumnSchema.newBuilder();
                builder.setColumnName(columnNames.get(i)).setSemanticType(semanticTypes.get(i)).setDatatype(dataTypes.get(i));
                rows.columnSchemas.add(builder.build());
            }
            return rows;
        }
    }

    public static enum WriteProtocol {
        Columnar,
        Row;

    }
}

