/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.models;

import io.greptime.common.util.Ensures;
import io.greptime.models.ColumnDataType;
import io.greptime.models.SemanticType;
import io.greptime.models.TableName;
import io.greptime.v1.Common;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class TableSchema {
    private static final Map<TableName, TableSchema> TABLE_SCHEMA_CACHE = new ConcurrentHashMap<TableName, TableSchema>();
    private TableName tableName;
    private List<String> columnNames;
    private List<Common.SemanticType> semanticTypes;
    private List<Common.ColumnDataType> dataTypes;

    private TableSchema() {
    }

    public TableName getTableName() {
        return this.tableName;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public List<Common.SemanticType> getSemanticTypes() {
        return this.semanticTypes;
    }

    public List<Common.ColumnDataType> getDataTypes() {
        return this.dataTypes;
    }

    public static TableSchema findSchema(TableName tableName) {
        return TABLE_SCHEMA_CACHE.get(tableName);
    }

    public static TableSchema removeSchema(TableName tableName) {
        return TABLE_SCHEMA_CACHE.remove(tableName);
    }

    public static void clearAllSchemas() {
        TABLE_SCHEMA_CACHE.clear();
    }

    public static Builder newBuilder(TableName tableName) {
        return new Builder(tableName);
    }

    public static class Builder {
        private final TableName tableName;
        private List<String> columnNames;
        private List<Common.SemanticType> semanticTypes;
        private List<Common.ColumnDataType> dataTypes;

        public Builder(TableName tableName) {
            this.tableName = tableName;
        }

        public Builder columnNames(String ... names) {
            this.columnNames = Arrays.stream(names).collect(Collectors.toList());
            return this;
        }

        public Builder semanticTypes(SemanticType ... semanticTypes) {
            this.semanticTypes = Arrays.stream(semanticTypes).map(SemanticType::toProtoValue).collect(Collectors.toList());
            return this;
        }

        public Builder dataTypes(ColumnDataType ... dataTypes) {
            this.dataTypes = Arrays.stream(dataTypes).map(ColumnDataType::toProtoValue).collect(Collectors.toList());
            return this;
        }

        public TableSchema build() {
            Ensures.ensureNonNull((Object)this.tableName, (String)"Null table name");
            Ensures.ensureNonNull(this.columnNames, (String)"Null column names");
            Ensures.ensureNonNull(this.semanticTypes, (String)"Null semantic types");
            Ensures.ensureNonNull(this.dataTypes, (String)"Null data types");
            int columnCount = this.columnNames.size();
            Ensures.ensure((columnCount > 0 ? 1 : 0) != 0, (Object)"Empty column names");
            Ensures.ensure((columnCount == this.semanticTypes.size() ? 1 : 0) != 0, (Object)"Column names size not equal to semantic types size");
            Ensures.ensure((columnCount == this.dataTypes.size() ? 1 : 0) != 0, (Object)"Column names size not equal to data types size");
            TableSchema tableSchema = new TableSchema();
            tableSchema.tableName = this.tableName;
            tableSchema.columnNames = this.columnNames;
            tableSchema.semanticTypes = this.semanticTypes;
            tableSchema.dataTypes = this.dataTypes;
            return tableSchema;
        }

        public TableSchema buildAndCache() {
            TableSchema tableSchema = this.build();
            TABLE_SCHEMA_CACHE.putIfAbsent(tableSchema.tableName, tableSchema);
            return tableSchema;
        }
    }
}

