/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.models;

import io.greptime.common.util.Ensures;
import io.greptime.common.util.Strings;
import java.util.Objects;

public class TableName {
    private String databaseName;
    private String tableName;

    public static TableName with(String databaseName, String tableName) {
        Ensures.ensure((boolean)Strings.isNotBlank((String)tableName), (Object)"blank `tableName`");
        TableName tn = new TableName();
        tn.setDatabaseName(databaseName);
        tn.setTableName(tableName);
        return tn;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String toString() {
        return "TableName{databaseName='" + this.databaseName + '\'' + ", tableName='" + this.tableName + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableName tableName1 = (TableName)o;
        return Objects.equals(this.getDatabaseName(), tableName1.getDatabaseName()) && Objects.equals(this.getTableName(), tableName1.getTableName());
    }

    public int hashCode() {
        return Objects.hash(this.getDatabaseName(), this.getTableName());
    }
}

