/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.models;

import com.google.protobuf.ByteStringHelper;
import io.greptime.models.Util;
import io.greptime.v1.Common;
import io.greptime.v1.RowData;

public final class RowHelper {
    public static void addValue(RowData.Row.Builder builder, Common.ColumnDataType dataType, Object value) {
        RowData.Value.Builder valueBuilder = RowData.Value.newBuilder();
        if (value == null) {
            builder.addValues(valueBuilder.build());
            return;
        }
        switch (dataType) {
            case INT8: {
                valueBuilder.setI8Value(((Integer)value).intValue());
                break;
            }
            case INT16: {
                valueBuilder.setI16Value(((Integer)value).intValue());
                break;
            }
            case INT32: {
                valueBuilder.setI32Value(((Integer)value).intValue());
                break;
            }
            case INT64: {
                valueBuilder.setI64Value(Util.getLongValue(value));
                break;
            }
            case UINT8: {
                valueBuilder.setU8Value(((Integer)value).intValue());
                break;
            }
            case UINT16: {
                valueBuilder.setU16Value(((Integer)value).intValue());
                break;
            }
            case UINT32: {
                valueBuilder.setU32Value(((Integer)value).intValue());
                break;
            }
            case UINT64: {
                valueBuilder.setU64Value(Util.getLongValue(value));
                break;
            }
            case FLOAT32: {
                valueBuilder.setF32Value(((Number)value).floatValue());
                break;
            }
            case FLOAT64: {
                valueBuilder.setF64Value(((Number)value).doubleValue());
                break;
            }
            case BOOLEAN: {
                valueBuilder.setBoolValue(((Boolean)value).booleanValue());
                break;
            }
            case BINARY: {
                valueBuilder.setBinaryValue(ByteStringHelper.wrap((byte[])((byte[])value)));
                break;
            }
            case STRING: {
                valueBuilder.setStringValue((String)value);
                break;
            }
            case DATE: {
                valueBuilder.setDateValue(Util.getDateValue(value));
                break;
            }
            case DATETIME: {
                valueBuilder.setDatetimeValue((long)Util.getDateTimeValue(value));
                break;
            }
            case TIMESTAMP_SECOND: {
                valueBuilder.setTimestampSecondValue(Util.getLongValue(value));
                break;
            }
            case TIMESTAMP_MILLISECOND: {
                valueBuilder.setTimestampMillisecondValue(Util.getLongValue(value));
                break;
            }
            case TIMESTAMP_NANOSECOND: {
                valueBuilder.setTimestampNanosecondValue(Util.getLongValue(value));
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported `data_type`: %s", dataType));
            }
        }
        builder.addValues(valueBuilder.build());
    }

    private RowHelper() {
    }
}

