/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.models;

import io.greptime.common.util.Ensures;
import java.util.function.Function;

public final class Result<Ok, Err> {
    public static final int FLOW_CONTROL = 503;
    private final Ok ok;
    private final Err err;

    public static <Ok, Err> Result<Ok, Err> ok(Ok ok) {
        Ensures.ensureNonNull(ok, (String)"null `ok`");
        return new Result<Ok, Object>(ok, null);
    }

    public static <Ok, Err> Result<Ok, Err> err(Err err) {
        Ensures.ensureNonNull(err, (String)"null `err`");
        return new Result<Object, Err>(null, err);
    }

    private Result(Ok ok, Err err) {
        this.ok = ok;
        this.err = err;
    }

    public boolean isOk() {
        return this.ok != null && this.err == null;
    }

    public Ok getOk() {
        return (Ok)Ensures.ensureNonNull(this.ok, (String)"null `ok`");
    }

    public Err getErr() {
        return (Err)Ensures.ensureNonNull(this.err, (String)"null `err`");
    }

    public <U> Result<U, Err> map(Function<Ok, U> mapper) {
        return this.isOk() ? Result.ok(mapper.apply(this.getOk())) : Result.err(this.getErr());
    }

    public <U> U mapOr(U defaultVal, Function<Ok, U> mapper) {
        return this.isOk() ? mapper.apply(this.getOk()) : defaultVal;
    }

    public <U> U mapOrElse(Function<Err, U> fallbackMapper, Function<Ok, U> mapper) {
        return this.isOk() ? mapper.apply(this.getOk()) : fallbackMapper.apply(this.getErr());
    }

    public <F> Result<Ok, F> mapErr(Function<Err, F> mapper) {
        return this.isOk() ? Result.ok(this.getOk()) : Result.err(mapper.apply(this.getErr()));
    }

    public <U> Result<U, Err> andThen(Function<Ok, Result<U, Err>> mapper) {
        return this.isOk() ? mapper.apply(this.getOk()) : Result.err(this.getErr());
    }

    public <F> Result<Ok, F> orElse(Function<Err, Result<Ok, F>> mapper) {
        return this.isOk() ? Result.ok(this.getOk()) : mapper.apply(this.getErr());
    }

    public Ok unwrapOr(Ok defaultVal) {
        return this.isOk() ? this.getOk() : defaultVal;
    }

    public Ok unwrapOrElse(Function<Err, Ok> mapper) {
        return this.isOk() ? this.getOk() : mapper.apply(this.getErr());
    }

    public String toString() {
        return "Result{ok=" + this.ok + ", err=" + this.err + '}';
    }
}

