/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.models;

import io.greptime.v1.Common;
import org.apache.arrow.vector.types.pojo.ArrowType;

public enum ColumnDataType {
    Bool,
    Int8,
    Int16,
    Int32,
    Int64,
    UInt8,
    UInt16,
    UInt32,
    UInt64,
    Float32,
    Float64,
    Binary,
    String,
    Date,
    DateTime,
    TimestampSecond,
    TimestampMillisecond,
    TimestampMicrosecond,
    TimestampNanosecond;


    public Common.ColumnDataType toProtoValue() {
        switch (this) {
            case Bool: {
                return Common.ColumnDataType.BOOLEAN;
            }
            case Int8: {
                return Common.ColumnDataType.INT8;
            }
            case Int16: {
                return Common.ColumnDataType.INT16;
            }
            case Int32: {
                return Common.ColumnDataType.INT32;
            }
            case Int64: {
                return Common.ColumnDataType.INT64;
            }
            case UInt8: {
                return Common.ColumnDataType.UINT8;
            }
            case UInt16: {
                return Common.ColumnDataType.UINT16;
            }
            case UInt32: {
                return Common.ColumnDataType.UINT32;
            }
            case UInt64: {
                return Common.ColumnDataType.UINT64;
            }
            case Float32: {
                return Common.ColumnDataType.FLOAT32;
            }
            case Float64: {
                return Common.ColumnDataType.FLOAT64;
            }
            case Binary: {
                return Common.ColumnDataType.BINARY;
            }
            case String: {
                return Common.ColumnDataType.STRING;
            }
            case Date: {
                return Common.ColumnDataType.DATE;
            }
            case DateTime: {
                return Common.ColumnDataType.DATETIME;
            }
            case TimestampSecond: {
                return Common.ColumnDataType.TIMESTAMP_SECOND;
            }
            case TimestampMillisecond: {
                return Common.ColumnDataType.TIMESTAMP_MILLISECOND;
            }
            case TimestampMicrosecond: {
                return Common.ColumnDataType.TIMESTAMP_MICROSECOND;
            }
            case TimestampNanosecond: {
                return Common.ColumnDataType.TIMESTAMP_NANOSECOND;
            }
        }
        return null;
    }

    public static ColumnDataType fromArrowType(ArrowType t) {
        switch (t.getTypeID()) {
            case Bool: {
                return Bool;
            }
            case Int: {
                return Int32;
            }
            case FloatingPoint: {
                return Float64;
            }
            case Binary: 
            case LargeBinary: {
                return Binary;
            }
            case Utf8: 
            case LargeUtf8: {
                return String;
            }
            case Date: {
                ArrowType.Date dateType = (ArrowType.Date)t;
                switch (dateType.getUnit()) {
                    case DAY: {
                        return Date;
                    }
                    case MILLISECOND: {
                        return DateTime;
                    }
                }
                return null;
            }
            case Timestamp: {
                ArrowType.Timestamp timestampType = (ArrowType.Timestamp)t;
                switch (timestampType.getUnit()) {
                    case SECOND: {
                        return TimestampSecond;
                    }
                    case MILLISECOND: {
                        return TimestampMillisecond;
                    }
                    case MICROSECOND: {
                        return TimestampMicrosecond;
                    }
                    case NANOSECOND: {
                        return TimestampNanosecond;
                    }
                }
                return null;
            }
        }
        return null;
    }
}

