/*
 * Decompiled with CFR 0.152.
 */
package io.greptime;

import io.greptime.Router;
import io.greptime.Util;
import io.greptime.common.Display;
import io.greptime.common.Endpoint;
import io.greptime.common.Lifecycle;
import io.greptime.common.util.Ensures;
import io.greptime.common.util.SharedScheduledPool;
import io.greptime.flight.GreptimeFlightClient;
import io.greptime.options.RouterOptions;
import io.greptime.rpc.Context;
import io.greptime.rpc.Observer;
import io.greptime.rpc.RpcClient;
import io.greptime.rpc.errors.RemotingException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterClient
implements Lifecycle<RouterOptions>,
Display {
    private static final Logger LOG = LoggerFactory.getLogger(RouterClient.class);
    private static final SharedScheduledPool REFRESHER_POOL = Util.getSharedScheduledPool("route_cache_refresher", 1);
    private ScheduledExecutorService refresher;
    private RouterOptions opts;
    private RpcClient rpcClient;
    private final ConcurrentHashMap<Endpoint, GreptimeFlightClient> flightClients = new ConcurrentHashMap();
    private InnerRouter inner;

    public boolean init(RouterOptions opts) {
        this.opts = ((RouterOptions)Ensures.ensureNonNull((Object)opts, (String)"null `RouterClient.opts`")).copy();
        this.rpcClient = this.opts.getRpcClient();
        List endpoints = (List)Ensures.ensureNonNull(this.opts.getEndpoints(), (String)"null `endpoints`");
        this.inner = new InnerRouter();
        this.inner.refreshLocal(endpoints);
        long refreshPeriod = this.opts.getRefreshPeriodSeconds();
        if (refreshPeriod > 0L) {
            this.refresher = (ScheduledExecutorService)REFRESHER_POOL.getObject();
            this.refresher.scheduleWithFixedDelay(() -> this.inner.refreshFromRemote(), Util.randomInitialDelay(180L), refreshPeriod, TimeUnit.SECONDS);
            LOG.info("Router cache refresher started.");
        }
        return true;
    }

    public void shutdownGracefully() {
        if (this.rpcClient != null) {
            this.rpcClient.shutdownGracefully();
        }
        Iterator<Map.Entry<Endpoint, GreptimeFlightClient>> iterator = this.flightClients.entrySet().iterator();
        while (iterator.hasNext()) {
            GreptimeFlightClient client = iterator.next().getValue();
            try {
                client.close();
            }
            catch (Exception ex) {
                LOG.warn("Failed to close " + client, (Throwable)ex);
                continue;
            }
            LOG.info("Closed {}", (Object)client);
            iterator.remove();
        }
        if (this.refresher != null) {
            REFRESHER_POOL.returnObject((Object)this.refresher);
            this.refresher = null;
        }
    }

    public CompletableFuture<Endpoint> route() {
        return this.inner.routeFor(null);
    }

    public GreptimeFlightClient getFlightClient(Endpoint endpoint) {
        return this.flightClients.computeIfAbsent(endpoint, GreptimeFlightClient::createClient);
    }

    public <Req, Resp> CompletableFuture<Resp> invoke(Endpoint endpoint, Req request, Context ctx) {
        return this.invoke(endpoint, request, ctx, -1L);
    }

    public <Req, Resp> CompletableFuture<Resp> invoke(Endpoint endpoint, Req request, Context ctx, long timeoutMs) {
        final CompletableFuture future = new CompletableFuture();
        try {
            this.rpcClient.invokeAsync(endpoint, request, ctx, new Observer<Resp>(){

                public void onNext(Resp value) {
                    future.complete(value);
                }

                public void onError(Throwable err) {
                    future.completeExceptionally(err);
                }
            }, timeoutMs);
        }
        catch (RemotingException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public <Req, Resp> void invokeServerStreaming(Endpoint endpoint, Req request, Context ctx, Observer<Resp> observer) {
        try {
            this.rpcClient.invokeServerStreaming(endpoint, request, ctx, observer);
        }
        catch (RemotingException e) {
            observer.onError((Throwable)e);
        }
    }

    public <Req, Resp> Observer<Req> invokeClientStreaming(Endpoint endpoint, Req defaultReqIns, Context ctx, Observer<Resp> respObserver) {
        try {
            return this.rpcClient.invokeClientStreaming(endpoint, defaultReqIns, ctx, respObserver);
        }
        catch (RemotingException e) {
            respObserver.onError((Throwable)e);
            return new Observer.RejectedObserver((Throwable)e);
        }
    }

    public void display(Display.Printer out) {
        out.println((Object)"--- RouterClient ---").print((Object)"opts=").println((Object)this.opts);
        if (this.rpcClient != null) {
            out.println((Object)"");
            this.rpcClient.display(out);
        }
        out.println((Object)"").println((Object)"Flight clients: ").print(this.flightClients.keys());
    }

    public String toString() {
        return "RouterClient{refresher=" + this.refresher + ", opts=" + this.opts + ", rpcClient=" + this.rpcClient + ", flightClients=" + this.flightClients + '}';
    }

    private static class InnerRouter
    implements Router<Void, Endpoint> {
        private final AtomicReference<List<Endpoint>> endpointsRef = new AtomicReference();

        private InnerRouter() {
        }

        public void refreshFromRemote() {
        }

        void refreshLocal(List<Endpoint> input) {
            this.endpointsRef.set(input);
        }

        @Override
        public CompletableFuture<Endpoint> routeFor(Void request) {
            List<Endpoint> endpoints = this.endpointsRef.get();
            ThreadLocalRandom random = ThreadLocalRandom.current();
            int i = random.nextInt(0, endpoints.size());
            return Util.completedCf(endpoints.get(i));
        }
    }
}

