/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.warehouse.store.realtime.redis;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.codec.RedisCodec;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.warehouse.store.realtime.AbstractRealTimeDataStorage;
import org.apache.hertzbeat.warehouse.store.realtime.redis.MetricsDataRedisCodec;
import org.apache.hertzbeat.warehouse.store.realtime.redis.RedisProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Primary;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Primary
@Component
@ConditionalOnProperty(prefix="warehouse.store.redis", name={"enabled"}, havingValue="true")
public class RedisDataStorage
extends AbstractRealTimeDataStorage {
    private static final Logger log = LoggerFactory.getLogger(RedisDataStorage.class);
    private RedisClient redisClient;
    private final Integer db;
    private StatefulRedisConnection<String, CollectRep.MetricsData> connection;

    public RedisDataStorage(RedisProperties redisProperties) {
        this.serverAvailable = this.initRedisClient(redisProperties);
        this.db = this.getRedisSelectDb(redisProperties);
    }

    private Integer getRedisSelectDb(RedisProperties redisProperties) {
        return redisProperties.db();
    }

    @Override
    public CollectRep.MetricsData getCurrentMetricsData(@NonNull Long monitorId, @NonNull String metric) {
        RedisCommands commands = this.connection.sync();
        commands.select(this.db.intValue());
        return (CollectRep.MetricsData)commands.hget((Object)String.valueOf(monitorId), (Object)metric);
    }

    @Override
    public List<CollectRep.MetricsData> getCurrentMetricsData(@NonNull Long monitorId) {
        RedisCommands commands = this.connection.sync();
        commands.select(this.db.intValue());
        Map metricsDataMap = commands.hgetall((Object)String.valueOf(monitorId));
        return new ArrayList<CollectRep.MetricsData>(metricsDataMap.values());
    }

    @Override
    public void saveData(CollectRep.MetricsData metricsData) {
        String key = String.valueOf(metricsData.getId());
        String hashKey = metricsData.getMetrics();
        if (metricsData.getCode() != CollectRep.Code.SUCCESS || !this.isServerAvailable()) {
            return;
        }
        if (metricsData.getValuesList().isEmpty()) {
            log.info("[warehouse redis] redis flush metrics data {} - {} is null, ignore.", (Object)key, (Object)hashKey);
            return;
        }
        RedisAsyncCommands commands = this.connection.async();
        commands.select(this.db.intValue());
        commands.hset((Object)key, (Object)hashKey, (Object)metricsData).thenAccept(response -> {
            if (response.booleanValue()) {
                log.debug("[warehouse] redis add new data {}:{}.", (Object)key, (Object)hashKey);
            } else {
                log.debug("[warehouse] redis replace data {}:{}.", (Object)key, (Object)hashKey);
            }
        });
    }

    private boolean initRedisClient(RedisProperties redisProperties) {
        if (redisProperties == null) {
            log.error("init error, please config Warehouse redis props in application.yml");
            return false;
        }
        RedisProperties redisProp = redisProperties;
        RedisURI.Builder uriBuilder = RedisURI.builder().withHost(redisProp.host()).withPort(redisProp.port().intValue()).withTimeout(Duration.of(10L, ChronoUnit.SECONDS));
        if (redisProp.password() != null && !"".equals(redisProp.password())) {
            uriBuilder.withPassword(redisProp.password().toCharArray());
        }
        try {
            this.redisClient = RedisClient.create((RedisURI)uriBuilder.build());
            this.connection = this.redisClient.connect((RedisCodec)new MetricsDataRedisCodec());
            return true;
        }
        catch (Exception e) {
            log.error("init redis error {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    public void destroy() {
        if (this.connection != null) {
            this.connection.close();
        }
        if (this.redisClient != null) {
            this.redisClient.shutdown();
        }
    }
}

