/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.warehouse.store.history.greptime;

import io.greptime.GreptimeDB;
import io.greptime.models.ColumnDataType;
import io.greptime.models.Err;
import io.greptime.models.QueryOk;
import io.greptime.models.QueryRequest;
import io.greptime.models.Result;
import io.greptime.models.Row;
import io.greptime.models.SelectExprType;
import io.greptime.models.SelectRows;
import io.greptime.models.SemanticType;
import io.greptime.models.TableName;
import io.greptime.models.TableSchema;
import io.greptime.models.WriteRows;
import io.greptime.options.GreptimeOptions;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.arrow.flight.FlightRuntimeException;
import org.apache.hertzbeat.common.entity.dto.Value;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.hertzbeat.common.util.TimePeriodUtil;
import org.apache.hertzbeat.warehouse.store.history.AbstractHistoryDataStorage;
import org.apache.hertzbeat.warehouse.store.history.greptime.GreptimeProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="warehouse.store.greptime", name={"enabled"}, havingValue="true")
public class GrepTimeDbDataStorage
extends AbstractHistoryDataStorage {
    private static final Logger log = LoggerFactory.getLogger(GrepTimeDbDataStorage.class);
    private static final String STORAGE_DATABASE = "hertzbeat";
    private static final String QUERY_HISTORY_SQL = "SELECT CAST (ts AS Int64) ts, instance, \"%s\" FROM %s WHERE ts >= %s and monitor_id = %s order by ts desc;";
    private static final String QUERY_HISTORY_WITH_INSTANCE_SQL = "SELECT CAST (ts AS Int64) ts, instance, \"%s\" FROM %s WHERE ts >= %s and monitor_id = %s and instance = %s order by ts desc;";
    private static final String QUERY_INSTANCE_SQL = "SELECT DISTINCT instance FROM %s WHERE ts >= now() - interval '1' WEEK";
    private static final String QUERY_HISTORY_INTERVAL_WITH_INSTANCE_SQL = "SELECT first, avg ,max, min FROM (SELECT \"%s\" as first FROM %s WHERE monitor_id = %s and ts >= %s and ts < %s ORDER BY ts LIMIT 1) LEFT JOIN (SELECT avg(\"%s\") as avg, min(\"%s\") as min, max(\"%s\") as max FROM %s WHERE ts >= %s and ts < %s) ON 1=1";
    private static final String TABLE_NOT_EXIST = "not exist";
    private static final String DATABASE_NOT_EXIST = "not exist";
    private GreptimeDB greptimeDb;

    public GrepTimeDbDataStorage(GreptimeProperties greptimeProperties) {
        this.serverAvailable = this.initDbSession(greptimeProperties);
    }

    private boolean initDbSession(GreptimeProperties properties) {
        String endpoint = properties.endpoint();
        GreptimeOptions opts = GreptimeOptions.newBuilder((String[])new String[]{endpoint}).writeMaxRetries(1).readMaxRetries(2).routeTableRefreshPeriodSeconds(-1L).build();
        this.greptimeDb = new GreptimeDB();
        if (!this.greptimeDb.init(opts)) {
            log.error("Fail to start Greptime client");
            return false;
        }
        return this.createDatabase();
    }

    private boolean createDatabase() {
        Result result;
        block8: {
            QueryRequest showDatabases = QueryRequest.newBuilder().exprType(SelectExprType.Sql).ql("SHOW DATABASES;").build();
            result = null;
            try {
                CompletableFuture future = this.greptimeDb.query(showDatabases);
                result = (Result)future.get();
            }
            catch (Exception e) {
                log.info("TABLE_NOT_EXIST: {}", (Object)e.getMessage());
                String msg = e.getMessage();
                if (msg == null || msg.contains("not exist")) break block8;
                log.warn(msg);
            }
        }
        boolean isDatabaseExist = false;
        if (result != null && result.isOk()) {
            QueryOk queryOk = (QueryOk)result.getOk();
            SelectRows rows = queryOk.getRows();
            List rowsList = rows.collect();
            block4: for (Row row : rowsList) {
                for (io.greptime.models.Value value : row.values()) {
                    if (!STORAGE_DATABASE.equals(value.value().toString())) continue;
                    log.info("Exist Database {}", (Object)STORAGE_DATABASE);
                    isDatabaseExist = true;
                    continue block4;
                }
            }
        }
        if (!isDatabaseExist) {
            QueryRequest createDatabase = QueryRequest.newBuilder().exprType(SelectExprType.Sql).ql("CREATE DATABASE %s;", new Object[]{STORAGE_DATABASE}).build();
            try {
                CompletableFuture createFuture = this.greptimeDb.query(createDatabase);
                isDatabaseExist = ((Result)createFuture.get()).isOk();
                log.info("Database {} does not exist,and has been created", (Object)STORAGE_DATABASE);
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("Error creating database");
            }
        }
        return isDatabaseExist;
    }

    @Override
    public void saveData(CollectRep.MetricsData metricsData) {
        block15: {
            if (!this.isServerAvailable() || metricsData.getCode() != CollectRep.Code.SUCCESS) {
                return;
            }
            if (metricsData.getValuesList().isEmpty()) {
                log.info("[warehouse greptime] flush metrics data {} is null, ignore.", (Object)metricsData.getId());
                return;
            }
            String monitorId = String.valueOf(metricsData.getId());
            String table = metricsData.getApp() + "_" + metricsData.getMetrics();
            TableSchema.Builder tableSchemaBuilder = TableSchema.newBuilder((TableName)TableName.with((String)STORAGE_DATABASE, (String)table));
            LinkedList<SemanticType> semanticTypes = new LinkedList<SemanticType>(Arrays.asList(SemanticType.Tag, SemanticType.Tag, SemanticType.Timestamp));
            LinkedList<ColumnDataType> dataTypes = new LinkedList<ColumnDataType>(Arrays.asList(ColumnDataType.String, ColumnDataType.String, ColumnDataType.TimestampMillisecond));
            LinkedList<String> columnNames = new LinkedList<String>(Arrays.asList("monitor_id", "instance", "ts"));
            List fieldsList = metricsData.getFieldsList();
            for (CollectRep.Field field : fieldsList) {
                semanticTypes.add(SemanticType.Field);
                columnNames.add(field.getName());
                if (field.getType() == 0) {
                    dataTypes.add(ColumnDataType.Float64);
                    continue;
                }
                if (field.getType() != 1) continue;
                dataTypes.add(ColumnDataType.String);
            }
            tableSchemaBuilder.semanticTypes(semanticTypes.toArray(new SemanticType[0]));
            tableSchemaBuilder.dataTypes(dataTypes.toArray(new ColumnDataType[0]));
            tableSchemaBuilder.columnNames(columnNames.toArray(new String[0]));
            WriteRows rows = WriteRows.newBuilder((TableSchema)tableSchemaBuilder.build()).build();
            try {
                long now = System.currentTimeMillis();
                Object[] values = new Object[3 + fieldsList.size()];
                values[0] = monitorId;
                values[2] = now;
                for (CollectRep.ValueRow valueRow : metricsData.getValuesList()) {
                    HashMap<String, String> labels = new HashMap<String, String>(8);
                    for (int i = 0; i < fieldsList.size(); ++i) {
                        if (!"&nbsp;".equals(valueRow.getColumns(i))) {
                            CollectRep.Field field = (CollectRep.Field)fieldsList.get(i);
                            if (field.getType() == 0) {
                                values[3 + i] = Double.parseDouble(valueRow.getColumns(i));
                            } else if (field.getType() == 1) {
                                values[3 + i] = valueRow.getColumns(i);
                            }
                            if (!field.getLabel()) continue;
                            labels.put(field.getName(), String.valueOf(values[3 + i]));
                            continue;
                        }
                        values[3 + i] = null;
                    }
                    values[1] = JsonUtil.toJson(labels);
                    rows.insert(values);
                }
                rows.finish();
                CompletableFuture writeFuture = this.greptimeDb.write(rows);
                try {
                    Result result = (Result)writeFuture.get(10L, TimeUnit.SECONDS);
                    if (result.isOk()) {
                        log.debug("[warehouse greptime]-Write successful");
                        break block15;
                    }
                    log.warn("[warehouse greptime]--Write failed: {}", (Object)((Err)result.getErr()).getFailedQl());
                }
                catch (Throwable throwable) {
                    log.error("[warehouse greptime]--Error occurred: {}", (Object)throwable.getMessage());
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public Map<String, List<Value>> getHistoryMetricData(Long monitorId, String app, String metrics, String metric, String label, String history) {
        HashMap<String, List<Value>> instanceValuesMap = new HashMap<String, List<Value>>(8);
        if (!this.isServerAvailable()) {
            log.error("\n\t---------------Greptime Init Failed---------------\n\t--------------Please Config Greptime--------------\n\t----------Can Not Use Metric History Now----------\n");
            return instanceValuesMap;
        }
        long expireTime = this.getExpireTimeFromToken(history);
        String table = app + "_" + metrics;
        String selectSql = label == null ? String.format(QUERY_HISTORY_SQL, metric, table, expireTime, monitorId) : String.format(QUERY_HISTORY_WITH_INSTANCE_SQL, metric, table, expireTime, monitorId, label);
        log.debug("selectSql: {}", (Object)selectSql);
        QueryRequest request = QueryRequest.newBuilder().exprType(SelectExprType.Sql).databaseName(STORAGE_DATABASE).ql(selectSql).build();
        try {
            CompletableFuture future = this.greptimeDb.query(request);
            Result result = (Result)future.get();
            if (result != null && result.isOk()) {
                QueryOk queryOk = (QueryOk)result.getOk();
                SelectRows rows = queryOk.getRows();
                List maps = rows.collectToMaps();
                for (Map map : maps) {
                    String instanceValue = map.get("instance") == null ? "" : map.get("instance").toString();
                    Object valueObj = map.get(metric);
                    if (valueObj == null) continue;
                    String strValue = new BigDecimal(valueObj.toString()).setScale(4, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
                    List valueList = instanceValuesMap.computeIfAbsent(instanceValue, k -> new LinkedList());
                    valueList.add(new Value(strValue, ((Long)map.get("ts")).longValue()));
                }
            }
        }
        catch (FlightRuntimeException e) {
            String msg = e.getMessage();
            if (msg != null && msg.contains("not exist")) {
                List valueList = instanceValuesMap.computeIfAbsent(metric, k -> new LinkedList());
                valueList.add(new Value(null, System.currentTimeMillis()));
                log.info("[warehouse greptime]-TABLE_NOT_EXIST: {}", (Object)table);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return instanceValuesMap;
    }

    private long getExpireTimeFromToken(String history) {
        long expireTime;
        try {
            TemporalAmount temporalAmount = TimePeriodUtil.parseTokenTime((String)history);
            ZonedDateTime dateTime = ZonedDateTime.now().minus(temporalAmount);
            expireTime = dateTime.toEpochSecond() * 1000L;
        }
        catch (Exception e) {
            log.error("parse history time error: {}. use default: 6h", (Object)e.getMessage());
            ZonedDateTime dateTime = ZonedDateTime.now().minus(Duration.ofHours(6L));
            expireTime = dateTime.toEpochSecond() * 1000L;
        }
        return expireTime;
    }

    @Override
    public Map<String, List<Value>> getHistoryIntervalMetricData(Long monitorId, String app, String metrics, String metric, String label, String history) {
        HashMap<String, List<Value>> instanceValuesMap = new HashMap<String, List<Value>>(8);
        if (!this.isServerAvailable()) {
            log.error("\n\t---------------Greptime Init Failed---------------\n\t--------------Please Config Greptime--------------\n\t----------Can Not Use Metric History Now----------\n");
            return instanceValuesMap;
        }
        String table = app + "_" + metrics;
        LinkedList<String> instances = new LinkedList<String>();
        if (label != null) {
            instances.add(label);
        }
        if (instances.isEmpty()) {
            String selectSql = String.format(QUERY_INSTANCE_SQL, table);
            log.debug("selectSql: {}", (Object)selectSql);
            QueryRequest request = QueryRequest.newBuilder().exprType(SelectExprType.Sql).databaseName(STORAGE_DATABASE).ql(selectSql).build();
            try {
                CompletableFuture future = this.greptimeDb.query(request);
                Result result = (Result)future.get();
                if (result != null && result.isOk()) {
                    QueryOk queryOk = (QueryOk)result.getOk();
                    SelectRows rows = queryOk.getRows();
                    while (rows.hasNext()) {
                        Row row = (Row)rows.next();
                        if (row == null) continue;
                        List values = row.values();
                        for (io.greptime.models.Value value : values) {
                            log.debug("value:{}", value.value());
                            Object instanceValue = value.value();
                            if (instanceValue == null || "".equals(instanceValue)) {
                                instances.add("''");
                                continue;
                            }
                            instances.add(instanceValue.toString());
                        }
                    }
                }
            }
            catch (FlightRuntimeException e) {
                String msg = e.getMessage();
                if (msg != null && msg.contains("not exist")) {
                    log.info("[warehouse greptime]-TABLE_NOT_EXIST: {}", (Object)table);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        long startTime = this.getExpireTimeFromToken(history);
        Calendar cal = Calendar.getInstance();
        long interval = System.currentTimeMillis() - startTime;
        long fourHourCount = TimeUnit.MILLISECONDS.toHours(interval) / 4L;
        int i = 0;
        while ((long)i < fourHourCount) {
            cal.clear();
            cal.setTimeInMillis(startTime);
            cal.add(11, 4);
            long endTime = cal.getTimeInMillis();
            for (String instanceValue : instances) {
                String selectSql = String.format(QUERY_HISTORY_INTERVAL_WITH_INSTANCE_SQL, metric, table, monitorId, startTime, endTime, metric, metric, metric, table, startTime, endTime);
                log.debug("selectSql: {}", (Object)selectSql);
                QueryRequest request = QueryRequest.newBuilder().exprType(SelectExprType.Sql).databaseName(STORAGE_DATABASE).ql(selectSql).build();
                List values = instanceValuesMap.computeIfAbsent(instanceValue, k -> new LinkedList());
                try {
                    CompletableFuture future = this.greptimeDb.query(request);
                    Result result = (Result)future.get();
                    log.debug("result:{}", (Object)result);
                    if (result == null || !result.isOk()) continue;
                    QueryOk queryOk = (QueryOk)result.getOk();
                    SelectRows rows = queryOk.getRows();
                    String[] col = new String[4];
                    while (rows.hasNext()) {
                        Row row = (Row)rows.next();
                        if (row.values().isEmpty()) continue;
                        for (int j = 0; j < row.values().size(); ++j) {
                            String colStr;
                            log.debug("value:{}", row.values().get(j));
                            col[j] = colStr = new BigDecimal(((io.greptime.models.Value)row.values().get(j)).value().toString()).setScale(4, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
                        }
                        Value valueBuild = Value.builder().origin(col[0]).mean(col[1]).min(col[2]).max(col[3]).time(Long.valueOf(System.currentTimeMillis())).build();
                        values.add(valueBuild);
                    }
                    log.debug("[warehouse greptime] values:{}", (Object)values);
                }
                catch (FlightRuntimeException e) {
                    String msg = e.getMessage();
                    if (msg == null || !msg.contains("not exist")) continue;
                    List valueList = instanceValuesMap.computeIfAbsent(metric, k -> new LinkedList());
                    valueList.add(new Value(null, System.currentTimeMillis()));
                    log.info("[warehouse greptime]-TABLE_NOT_EXIST: {}", (Object)table);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            startTime = endTime;
            ++i;
        }
        return instanceValuesMap;
    }

    public void destroy() {
        if (this.greptimeDb != null) {
            this.greptimeDb.shutdownGracefully();
        }
    }
}

