/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.warehouse.listener;

import java.util.Optional;
import org.apache.hertzbeat.warehouse.store.history.AbstractHistoryDataStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class WareHouseApplicationReadyListener {
    private static final Logger log = LoggerFactory.getLogger(WareHouseApplicationReadyListener.class);
    private Optional<AbstractHistoryDataStorage> historyDataStorage;

    public WareHouseApplicationReadyListener(Optional<AbstractHistoryDataStorage> historyDataStorage) {
        this.historyDataStorage = historyDataStorage;
    }

    @EventListener(classes={ApplicationReadyEvent.class})
    public void listen() {
        if (this.historyDataStorage.isEmpty()) {
            log.warn("The historical data repository is not configured");
        }
    }
}

