/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.warehouse.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hertzbeat.common.entity.dto.Field;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.apache.hertzbeat.common.entity.dto.MetricsData;
import org.apache.hertzbeat.common.entity.dto.MetricsHistoryData;
import org.apache.hertzbeat.common.entity.dto.Value;
import org.apache.hertzbeat.common.entity.dto.ValueRow;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.warehouse.store.history.HistoryDataReader;
import org.apache.hertzbeat.warehouse.store.realtime.RealTimeDataReader;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(produces={"application/json"})
@Tag(name="Metrics Data API | The API for monitoring metric data")
public class MetricsDataController {
    private static final Integer METRIC_FULL_LENGTH = 3;
    private final RealTimeDataReader realTimeDataReader;
    private final Optional<HistoryDataReader> historyDataReader;

    public MetricsDataController(RealTimeDataReader realTimeDataReader, Optional<HistoryDataReader> historyDataReader) {
        this.realTimeDataReader = realTimeDataReader;
        this.historyDataReader = historyDataReader;
    }

    @GetMapping(value={"/api/warehouse/storage/status"})
    @Operation(summary="Query Warehouse Storage Server Status", description="Query the availability status of the storage service under the warehouse")
    public ResponseEntity<Message<Void>> getWarehouseStorageServerStatus() {
        if (this.historyDataReader.isPresent() && this.historyDataReader.get().isServerAvailable()) {
            return ResponseEntity.ok((Object)Message.success());
        }
        return ResponseEntity.ok((Object)Message.fail((byte)15, (String)"Service not available!"));
    }

    @GetMapping(value={"/api/monitor/{monitorId}/metrics/{metrics}"})
    @Operation(summary="Query Real Time Metrics Data", description="Query real-time metrics data of monitoring indicators")
    public ResponseEntity<Message<MetricsData>> getMetricsData(@Parameter(description="Monitor Id", example="343254354") @PathVariable Long monitorId, @Parameter(description="Metrics Name", example="cpu") @PathVariable String metrics) {
        boolean available = this.realTimeDataReader.isServerAvailable();
        if (!available) {
            return ResponseEntity.ok((Object)Message.fail((byte)15, (String)"real time store not available"));
        }
        CollectRep.MetricsData storageData = this.realTimeDataReader.getCurrentMetricsData(monitorId, metrics);
        if (storageData == null) {
            return ResponseEntity.ok((Object)Message.success((String)"query metrics data is empty"));
        }
        MetricsData.MetricsDataBuilder dataBuilder = MetricsData.builder();
        dataBuilder.id(Long.valueOf(storageData.getId())).app(storageData.getApp()).metrics(storageData.getMetrics()).time(Long.valueOf(storageData.getTime()));
        List fields = storageData.getFieldsList().stream().map(tmpField -> Field.builder().name(tmpField.getName()).type(Byte.valueOf(Integer.valueOf(tmpField.getType()).byteValue())).label(Boolean.valueOf(tmpField.getLabel())).unit(tmpField.getUnit()).build()).collect(Collectors.toList());
        dataBuilder.fields(fields);
        LinkedList<ValueRow> valueRows = new LinkedList<ValueRow>();
        for (CollectRep.ValueRow valueRow : storageData.getValuesList()) {
            HashMap<String, String> labels = new HashMap<String, String>(8);
            LinkedList<Value> values = new LinkedList<Value>();
            for (int i = 0; i < fields.size(); ++i) {
                Field field = (Field)fields.get(i);
                String origin = valueRow.getColumns(i);
                if ("&nbsp;".equals(origin)) {
                    values.add(new Value());
                    continue;
                }
                values.add(new Value(origin));
                if (!field.getLabel().booleanValue()) continue;
                labels.put(field.getName(), origin);
            }
            valueRows.add(ValueRow.builder().labels(labels).values(values).build());
        }
        dataBuilder.valueRows(valueRows);
        return ResponseEntity.ok((Object)Message.success((Object)dataBuilder.build()));
    }

    @GetMapping(value={"/api/monitor/{monitorId}/metric/{metricFull}"})
    @Operation(summary="Queries historical data for a specified metric for monitoring", description="Queries historical data for a specified metric under monitoring")
    public ResponseEntity<Message<MetricsHistoryData>> getMetricHistoryData(@Parameter(description="monitor the task ID", example="343254354") @PathVariable Long monitorId, @Parameter(description="monitor metric full path", example="linux.cpu.usage") @PathVariable String metricFull, @Parameter(description="label filter, empty by default", example="disk2") @RequestParam(required=false) String label, @Parameter(description="query historical time period, default 6h-6 hours: s-seconds, M-minutes, h-hours, d-days, w-weeks", example="6h") @RequestParam(required=false) String history, @Parameter(description="aggregate data calc. off by default; 4-hour window, query limit >1 week", example="false") @RequestParam(required=false) Boolean interval) {
        if (this.historyDataReader.isEmpty() || !this.historyDataReader.get().isServerAvailable()) {
            return ResponseEntity.ok((Object)Message.fail((byte)15, (String)"time series database not available"));
        }
        String[] names = metricFull.split("\\.");
        if (names.length != METRIC_FULL_LENGTH) {
            throw new IllegalArgumentException("metrics full name: " + metricFull + " is illegal.");
        }
        String app = names[0];
        String metrics = names[1];
        String metric = names[2];
        if (history == null) {
            history = "6h";
        }
        Map<String, List<Value>> instanceValuesMap = interval == null || interval == false ? this.historyDataReader.get().getHistoryMetricData(monitorId, app, metrics, metric, label, history) : this.historyDataReader.get().getHistoryIntervalMetricData(monitorId, app, metrics, metric, label, history);
        MetricsHistoryData historyData = MetricsHistoryData.builder().id(monitorId).metrics(metrics).values(instanceValuesMap).field(Field.builder().name(metric).type(Byte.valueOf((byte)0)).build()).build();
        return ResponseEntity.ok((Object)Message.success((Object)historyData));
    }
}

