/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.util;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AlertTemplateUtil {
    private static final Logger log = LoggerFactory.getLogger(AlertTemplateUtil.class);
    private static final Pattern PATTERN = Pattern.compile("\\$\\{(\\w+)\\}");

    private AlertTemplateUtil() {
    }

    public static String render(String template, Map<String, Object> replaceData) {
        if (template == null) {
            return null;
        }
        if (replaceData == null) {
            log.warn("The replaceData is null.");
            return template;
        }
        try {
            Matcher matcher = PATTERN.matcher(template);
            StringBuilder builder = new StringBuilder();
            while (matcher.find()) {
                Object objectValue = replaceData.getOrDefault(matcher.group(1), "NullValue");
                String value = objectValue.toString();
                matcher.appendReplacement(builder, Matcher.quoteReplacement(value));
            }
            matcher.appendTail(builder);
            return builder.toString();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return template;
        }
    }
}

