/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.service.impl;

import java.util.Arrays;
import java.util.Set;
import org.apache.hertzbeat.alert.dao.AlertSilenceDao;
import org.apache.hertzbeat.alert.service.AlertSilenceService;
import org.apache.hertzbeat.common.cache.CacheFactory;
import org.apache.hertzbeat.common.cache.CommonCacheService;
import org.apache.hertzbeat.common.entity.alerter.AlertSilence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class AlertSilenceServiceImpl
implements AlertSilenceService {
    private static final Logger log = LoggerFactory.getLogger(AlertSilenceServiceImpl.class);
    @Autowired
    private AlertSilenceDao alertSilenceDao;

    @Override
    public void validate(AlertSilence alertSilence, boolean isModify) throws IllegalArgumentException {
        if (alertSilence.getType() == 1 && alertSilence.getDays() == null) {
            alertSilence.setDays(Arrays.asList((byte)7, (byte)1, (byte)2, (byte)3, (byte)4, (byte)5, (byte)6));
        }
    }

    @Override
    public void addAlertSilence(AlertSilence alertSilence) throws RuntimeException {
        this.alertSilenceDao.save(alertSilence);
        this.clearAlertSilencesCache();
    }

    @Override
    public void modifyAlertSilence(AlertSilence alertSilence) throws RuntimeException {
        this.alertSilenceDao.save(alertSilence);
        this.clearAlertSilencesCache();
    }

    @Override
    public AlertSilence getAlertSilence(long silenceId) throws RuntimeException {
        return this.alertSilenceDao.findById(silenceId).orElse(null);
    }

    @Override
    public void deleteAlertSilences(Set<Long> silenceIds) throws RuntimeException {
        this.alertSilenceDao.deleteAlertSilencesByIdIn(silenceIds);
        this.clearAlertSilencesCache();
    }

    @Override
    public Page<AlertSilence> getAlertSilences(Specification<AlertSilence> specification, PageRequest pageRequest) {
        return this.alertSilenceDao.findAll(specification, (Pageable)pageRequest);
    }

    private void clearAlertSilencesCache() {
        CommonCacheService silenceCache = CacheFactory.getAlertSilenceCache();
        silenceCache.remove((Object)"alert_silence");
    }
}

