/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.service.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hertzbeat.alert.dao.AlertDao;
import org.apache.hertzbeat.alert.dto.AlertPriorityNum;
import org.apache.hertzbeat.alert.dto.AlertSummary;
import org.apache.hertzbeat.alert.reduce.AlarmCommonReduce;
import org.apache.hertzbeat.alert.service.AlertService;
import org.apache.hertzbeat.common.entity.alerter.Alert;
import org.apache.hertzbeat.common.entity.dto.AlertReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class AlertServiceImpl
implements AlertService {
    private static final Logger log = LoggerFactory.getLogger(AlertServiceImpl.class);
    @Autowired
    private AlertDao alertDao;
    @Autowired
    private AlarmCommonReduce alarmCommonReduce;

    @Override
    public void addAlert(Alert alert) throws RuntimeException {
        this.alertDao.save(alert);
    }

    @Override
    public Page<Alert> getAlerts(Specification<Alert> specification, PageRequest pageRequest) {
        return this.alertDao.findAll(specification, (Pageable)pageRequest);
    }

    @Override
    public void deleteAlerts(HashSet<Long> ids) {
        this.alertDao.deleteAlertsByIdIn(ids);
    }

    @Override
    public void clearAlerts() {
        this.alertDao.deleteAll();
    }

    @Override
    public void editAlertStatus(Byte status, List<Long> ids) {
        this.alertDao.updateAlertsStatus(status, ids);
    }

    @Override
    public AlertSummary getAlertsSummary() {
        AlertSummary alertSummary = new AlertSummary();
        List<AlertPriorityNum> priorityNums = this.alertDao.findAlertPriorityNum();
        if (priorityNums != null) {
            for (AlertPriorityNum priorityNum : priorityNums) {
                switch (priorityNum.getPriority()) {
                    case 2: {
                        alertSummary.setPriorityWarningNum(priorityNum.getNum());
                        break;
                    }
                    case 1: {
                        alertSummary.setPriorityCriticalNum(priorityNum.getNum());
                        break;
                    }
                    case 0: {
                        alertSummary.setPriorityEmergencyNum(priorityNum.getNum());
                        break;
                    }
                }
            }
        }
        long total = this.alertDao.count();
        alertSummary.setTotal(total);
        long dealNum = total - alertSummary.getPriorityCriticalNum() - alertSummary.getPriorityEmergencyNum() - alertSummary.getPriorityWarningNum();
        alertSummary.setDealNum(dealNum);
        try {
            if (total == 0L) {
                alertSummary.setRate(100.0f);
            } else {
                float rate = BigDecimal.valueOf(100.0f * (float)dealNum / (float)total).setScale(2, RoundingMode.HALF_UP).floatValue();
                alertSummary.setRate(rate);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return alertSummary;
    }

    @Override
    public void addNewAlertReport(AlertReport alertReport) {
        this.alarmCommonReduce.reduceAndSendAlarm(this.buildAlertData(alertReport));
    }

    @Override
    public List<Alert> getAlerts(Specification<Alert> specification) {
        return this.alertDao.findAll(specification);
    }

    private Alert buildAlertData(AlertReport alertReport) {
        Map annotations = alertReport.getAnnotations();
        StringBuilder sb = new StringBuilder();
        if (alertReport.getContent() == null || alertReport.getContent().length() <= 0) {
            StringBuilder finalSb = sb;
            annotations.forEach((k, v) -> finalSb.append((String)k).append(":").append((String)v).append("\n"));
        } else {
            sb = new StringBuilder(alertReport.getContent());
        }
        LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(alertReport.getAlertTime()), ZoneId.systemDefault());
        return Alert.builder().content("Alert Center\n" + sb).priority(alertReport.getPriority().byteValue()).status((byte)0).tags(alertReport.getLabels()).target(alertReport.getAlertName()).triggerTimes(Integer.valueOf(1)).firstAlarmTime(Long.valueOf(alertReport.getAlertTime())).lastAlarmTime(Long.valueOf(alertReport.getAlertTime())).gmtCreate(dateTime).gmtUpdate(dateTime).build();
    }
}

