/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.hertzbeat.alert.service.impl.AlertDefineAbstractImExportServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AlertDefineJsonImExportServiceImpl
extends AlertDefineAbstractImExportServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(AlertDefineJsonImExportServiceImpl.class);
    public static final String TYPE = "JSON";
    public static final String FILE_SUFFIX = ".json";
    private final ObjectMapper objectMapper;

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public String getFileName() {
        return this.fileNamePrefix() + FILE_SUFFIX;
    }

    @Override
    List<AlertDefineAbstractImExportServiceImpl.ExportAlertDefineDTO> parseImport(InputStream is) {
        try {
            return (List)this.objectMapper.readValue(is, (TypeReference)new TypeReference<List<AlertDefineAbstractImExportServiceImpl.ExportAlertDefineDTO>>(){});
        }
        catch (IOException ex) {
            log.error("import alertDefine failed.", (Throwable)ex);
            throw new RuntimeException("import alertDefine failed");
        }
    }

    @Override
    void writeOs(List<AlertDefineAbstractImExportServiceImpl.ExportAlertDefineDTO> exportAlertDefineList, OutputStream os) {
        try {
            this.objectMapper.writeValue(os, exportAlertDefineList);
        }
        catch (IOException ex) {
            log.error("export alertDefine failed.", (Throwable)ex);
            throw new RuntimeException("export alertDefine failed");
        }
    }

    public AlertDefineJsonImExportServiceImpl(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

