/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.hertzbeat.alert.service.impl.AlertDefineAbstractImExportServiceImpl;
import org.apache.hertzbeat.common.entity.manager.TagItem;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AlertDefineExcelImExportServiceImpl
extends AlertDefineAbstractImExportServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(AlertDefineExcelImExportServiceImpl.class);
    public static final String TYPE = "EXCEL";
    public static final String FILE_SUFFIX = ".xlsx";

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public String getFileName() {
        return this.fileNamePrefix() + FILE_SUFFIX;
    }

    @Override
    List<AlertDefineAbstractImExportServiceImpl.ExportAlertDefineDTO> parseImport(InputStream is) {
        ArrayList<AlertDefineAbstractImExportServiceImpl.ExportAlertDefineDTO> arrayList;
        block9: {
            Workbook workbook = WorkbookFactory.create((InputStream)is);
            try {
                Sheet sheet = workbook.getSheetAt(0);
                ArrayList<AlertDefineAbstractImExportServiceImpl.ExportAlertDefineDTO> alertDefines = new ArrayList<AlertDefineAbstractImExportServiceImpl.ExportAlertDefineDTO>();
                for (Row row : sheet) {
                    String app;
                    if (row.getRowNum() == 0 || !StringUtils.hasText((String)(app = this.getCellValueAsString(row.getCell(0))))) continue;
                    AlertDefineAbstractImExportServiceImpl.AlertDefineDTO alertDefineDTO = this.extractAlertDefineDataFromRow(row);
                    AlertDefineAbstractImExportServiceImpl.ExportAlertDefineDTO exportAlertDefineDTO = new AlertDefineAbstractImExportServiceImpl.ExportAlertDefineDTO();
                    exportAlertDefineDTO.setAlertDefine(alertDefineDTO);
                    alertDefines.add(exportAlertDefineDTO);
                }
                arrayList = alertDefines;
                if (workbook == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (workbook != null) {
                        try {
                            workbook.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to parse alertDefine data", e);
                }
            }
            workbook.close();
        }
        return arrayList;
    }

    private TagItem extractTagDataFromRow(Row row) {
        String name = this.getCellValueAsString(row.getCell(7));
        if (StringUtils.hasText((String)name)) {
            TagItem tagItem = new TagItem();
            tagItem.setName(name);
            tagItem.setValue(this.getCellValueAsString(row.getCell(8)));
            return tagItem;
        }
        return null;
    }

    private List<TagItem> extractTagDataFromRow(Cell cell) {
        String jsonStr = this.getCellValueAsString(cell);
        if (StringUtils.hasText((String)jsonStr)) {
            return (List)JsonUtil.fromJson((String)jsonStr, (TypeReference)new TypeReference<List<TagItem>>(){});
        }
        return null;
    }

    private String getCellValueAsString(Cell cell) {
        if (cell == null) {
            return null;
        }
        return switch (cell.getCellType()) {
            case CellType.STRING -> cell.getStringCellValue();
            case CellType.NUMERIC -> String.valueOf(cell.getNumericCellValue());
            default -> null;
        };
    }

    private boolean getCellValueAsBoolean(Cell cell) {
        if (cell == null) {
            return false;
        }
        if (Objects.requireNonNull(cell.getCellType()) == CellType.BOOLEAN) {
            return cell.getBooleanCellValue();
        }
        return false;
    }

    private Integer getCellValueAsInteger(Cell cell) {
        if (cell == null) {
            return null;
        }
        if (Objects.requireNonNull(cell.getCellType()) == CellType.NUMERIC) {
            return (int)cell.getNumericCellValue();
        }
        return null;
    }

    private Byte getCellValueAsByte(Cell cell) {
        if (cell == null) {
            return null;
        }
        if (Objects.requireNonNull(cell.getCellType()) == CellType.NUMERIC) {
            return (byte)cell.getNumericCellValue();
        }
        return null;
    }

    private AlertDefineAbstractImExportServiceImpl.AlertDefineDTO extractAlertDefineDataFromRow(Row row) {
        AlertDefineAbstractImExportServiceImpl.AlertDefineDTO alertDefineDTO = new AlertDefineAbstractImExportServiceImpl.AlertDefineDTO();
        alertDefineDTO.setApp(this.getCellValueAsString(row.getCell(0)));
        alertDefineDTO.setMetric(this.getCellValueAsString(row.getCell(1)));
        alertDefineDTO.setField(this.getCellValueAsString(row.getCell(2)));
        alertDefineDTO.setPreset(this.getCellValueAsBoolean(row.getCell(3)));
        alertDefineDTO.setExpr(this.getCellValueAsString(row.getCell(4)));
        alertDefineDTO.setPriority(this.getCellValueAsByte(row.getCell(5)));
        alertDefineDTO.setTimes(this.getCellValueAsInteger(row.getCell(6)));
        alertDefineDTO.setTags(this.extractTagDataFromRow(row.getCell(7)));
        alertDefineDTO.setEnable(this.getCellValueAsBoolean(row.getCell(8)));
        alertDefineDTO.setRecoverNotice(this.getCellValueAsBoolean(row.getCell(9)));
        alertDefineDTO.setTemplate(this.getCellValueAsString(row.getCell(10)));
        return alertDefineDTO;
    }

    @Override
    void writeOs(List<AlertDefineAbstractImExportServiceImpl.ExportAlertDefineDTO> exportAlertDefineList, OutputStream os) {
        try {
            Workbook workbook = WorkbookFactory.create((boolean)true);
            String sheetName = "Export AlertDefine";
            Sheet sheet = workbook.createSheet(sheetName);
            sheet.setDefaultColumnWidth(20);
            sheet.setColumnWidth(9, 10240);
            sheet.setColumnWidth(10, 10240);
            CellStyle headerCellStyle = workbook.createCellStyle();
            Font headerFont = workbook.createFont();
            headerFont.setBold(true);
            headerCellStyle.setFont(headerFont);
            headerCellStyle.setAlignment(HorizontalAlignment.CENTER);
            CellStyle cellStyle = workbook.createCellStyle();
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            String[] headers = new String[]{"app", "metric", "field", "preset", "expr", "priority", "times", "tags", "enable", "recoverNotice", "template"};
            Row headerRow = sheet.createRow(0);
            for (int i = 0; i < headers.length; ++i) {
                Cell cell = headerRow.createCell(i);
                cell.setCellValue(headers[i]);
                cell.setCellStyle(headerCellStyle);
            }
            int rowIndex = 1;
            for (AlertDefineAbstractImExportServiceImpl.ExportAlertDefineDTO alertDefine : exportAlertDefineList) {
                AlertDefineAbstractImExportServiceImpl.AlertDefineDTO alertDefineDTO = alertDefine.getAlertDefine();
                Row row = sheet.createRow(rowIndex++);
                Cell appCell = row.createCell(0);
                appCell.setCellValue(alertDefineDTO.getApp());
                appCell.setCellStyle(cellStyle);
                Cell metricCell = row.createCell(1);
                metricCell.setCellValue(alertDefineDTO.getMetric());
                metricCell.setCellStyle(cellStyle);
                Cell fieldCell = row.createCell(2);
                fieldCell.setCellValue(alertDefineDTO.getField());
                fieldCell.setCellStyle(cellStyle);
                Cell presetCell = row.createCell(3);
                presetCell.setCellValue(alertDefineDTO.getPreset() != null && alertDefineDTO.getPreset() != false);
                presetCell.setCellStyle(cellStyle);
                Cell exprCell = row.createCell(4);
                exprCell.setCellValue(alertDefineDTO.getExpr());
                exprCell.setCellStyle(cellStyle);
                Cell priorityCell = row.createCell(5);
                priorityCell.setCellValue((double)alertDefineDTO.getPriority().byteValue());
                priorityCell.setCellStyle(cellStyle);
                Cell timesCell = row.createCell(6);
                timesCell.setCellValue((double)alertDefineDTO.getTimes().intValue());
                Cell tagCell = row.createCell(7);
                List<TagItem> tagList = alertDefineDTO.getTags();
                String tagValue = tagList == null || tagList.isEmpty() ? "" : JsonUtil.toJson(tagList);
                tagCell.setCellValue(tagValue);
                tagCell.setCellStyle(cellStyle);
                Cell enableCell = row.createCell(8);
                enableCell.setCellValue(alertDefineDTO.getEnable() != null && alertDefineDTO.getEnable() != false);
                enableCell.setCellStyle(cellStyle);
                Cell recoverNoticeCell = row.createCell(9);
                recoverNoticeCell.setCellValue(alertDefineDTO.getRecoverNotice() != null && alertDefineDTO.getRecoverNotice() != false);
                recoverNoticeCell.setCellStyle(cellStyle);
                Cell templateCell = row.createCell(10);
                templateCell.setCellValue(alertDefineDTO.getTemplate());
                recoverNoticeCell.setCellStyle(cellStyle);
            }
            workbook.write(os);
            os.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

