/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.service.impl;

import java.util.Set;
import org.apache.hertzbeat.alert.dao.AlertConvergeDao;
import org.apache.hertzbeat.alert.service.AlertConvergeService;
import org.apache.hertzbeat.common.cache.CacheFactory;
import org.apache.hertzbeat.common.cache.CommonCacheService;
import org.apache.hertzbeat.common.entity.alerter.AlertConverge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class AlertConvergeServiceImpl
implements AlertConvergeService {
    private static final Logger log = LoggerFactory.getLogger(AlertConvergeServiceImpl.class);
    @Autowired
    private AlertConvergeDao alertConvergeDao;

    @Override
    public void validate(AlertConverge alertConverge, boolean isModify) throws IllegalArgumentException {
    }

    @Override
    public void addAlertConverge(AlertConverge alertConverge) throws RuntimeException {
        this.alertConvergeDao.save(alertConverge);
        this.clearAlertConvergesCache();
    }

    @Override
    public void modifyAlertConverge(AlertConverge alertConverge) throws RuntimeException {
        this.alertConvergeDao.save(alertConverge);
        this.clearAlertConvergesCache();
    }

    @Override
    public AlertConverge getAlertConverge(long convergeId) throws RuntimeException {
        return this.alertConvergeDao.findById(convergeId).orElse(null);
    }

    @Override
    public void deleteAlertConverges(Set<Long> convergeIds) throws RuntimeException {
        this.alertConvergeDao.deleteAlertConvergesByIdIn(convergeIds);
        this.clearAlertConvergesCache();
    }

    @Override
    public Page<AlertConverge> getAlertConverges(Specification<AlertConverge> specification, PageRequest pageRequest) {
        return this.alertConvergeDao.findAll(specification, (Pageable)pageRequest);
    }

    private void clearAlertConvergesCache() {
        CommonCacheService convergeCache = CacheFactory.getAlertConvergeCache();
        convergeCache.remove((Object)"alert_converge");
    }
}

