/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.reduce;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hertzbeat.alert.dao.AlertSilenceDao;
import org.apache.hertzbeat.common.cache.CacheFactory;
import org.apache.hertzbeat.common.cache.CommonCacheService;
import org.apache.hertzbeat.common.entity.alerter.Alert;
import org.apache.hertzbeat.common.entity.alerter.AlertSilence;
import org.springframework.stereotype.Service;

@Service
public class AlarmSilenceReduce {
    private final AlertSilenceDao alertSilenceDao;

    public boolean filterSilence(Alert alert) {
        CommonCacheService silenceCache = CacheFactory.getAlertSilenceCache();
        List alertSilenceList = (List)silenceCache.get((Object)"alert_silence");
        if (alertSilenceList == null) {
            alertSilenceList = this.alertSilenceDao.findAll();
            silenceCache.put((Object)"alert_silence", (Object)alertSilenceList);
        }
        for (AlertSilence alertSilence : alertSilenceList) {
            boolean endMatch;
            boolean dayMatch;
            if (!alertSilence.isEnable()) continue;
            boolean match = alertSilence.isMatchAll();
            if (!match) {
                List tags = alertSilence.getTags();
                if (alert.getTags() != null && !alert.getTags().isEmpty()) {
                    Map alertTagMap = alert.getTags();
                    match = tags.stream().anyMatch(item -> {
                        if (alertTagMap.containsKey(item.getName())) {
                            String tagValue = (String)alertTagMap.get(item.getName());
                            if (tagValue == null && item.getValue() == null) {
                                return true;
                            }
                            return tagValue != null && tagValue.equals(item.getValue());
                        }
                        return false;
                    });
                } else {
                    match = true;
                }
                if (match && alertSilence.getPriorities() != null && !alertSilence.getPriorities().isEmpty()) {
                    match = alertSilence.getPriorities().stream().anyMatch(item -> item != null && item.byteValue() == alert.getPriority());
                }
            }
            if (!match) continue;
            LocalDateTime nowDate = LocalDateTime.now();
            if (alertSilence.getType() == 0) {
                boolean endMatch2;
                boolean startMatch = alertSilence.getPeriodStart() == null || nowDate.isAfter(alertSilence.getPeriodStart().toLocalDateTime());
                boolean bl = endMatch2 = alertSilence.getPeriodEnd() == null || nowDate.isBefore(alertSilence.getPeriodEnd().toLocalDateTime());
                if (!startMatch || !endMatch2) continue;
                int times = Optional.ofNullable(alertSilence.getTimes()).orElse(0);
                alertSilence.setTimes(Integer.valueOf(times + 1));
                this.alertSilenceDao.save(alertSilence);
                return false;
            }
            if (alertSilence.getType() != 1) continue;
            int currentDayOfWeek = nowDate.toLocalDate().getDayOfWeek().getValue();
            if (alertSilence.getDays() == null || alertSilence.getDays().isEmpty() || !(dayMatch = alertSilence.getDays().stream().anyMatch(item -> item == currentDayOfWeek))) continue;
            LocalTime nowTime = nowDate.toLocalTime();
            boolean startMatch = alertSilence.getPeriodStart() == null || nowTime.isAfter(alertSilence.getPeriodStart().toLocalTime());
            boolean bl = endMatch = alertSilence.getPeriodEnd() == null || nowTime.isBefore(alertSilence.getPeriodEnd().toLocalTime());
            if (!startMatch || !endMatch) continue;
            int times = Optional.ofNullable(alertSilence.getTimes()).orElse(0);
            alertSilence.setTimes(Integer.valueOf(times + 1));
            this.alertSilenceDao.save(alertSilence);
            return false;
        }
        return true;
    }

    public AlarmSilenceReduce(AlertSilenceDao alertSilenceDao) {
        this.alertSilenceDao = alertSilenceDao;
    }
}

