/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.reduce;

import java.util.HashMap;
import java.util.List;
import org.apache.hertzbeat.alert.dao.AlertMonitorDao;
import org.apache.hertzbeat.alert.reduce.AlarmConvergeReduce;
import org.apache.hertzbeat.alert.reduce.AlarmSilenceReduce;
import org.apache.hertzbeat.common.entity.alerter.Alert;
import org.apache.hertzbeat.common.entity.manager.Tag;
import org.apache.hertzbeat.common.queue.CommonDataQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AlarmCommonReduce {
    private static final Logger log = LoggerFactory.getLogger(AlarmCommonReduce.class);
    private final AlarmSilenceReduce alarmSilenceReduce;
    private final AlarmConvergeReduce alarmConvergeReduce;
    private final CommonDataQueue dataQueue;
    private final AlertMonitorDao alertMonitorDao;

    public void reduceAndSendAlarm(Alert alert) {
        String monitorIdStr;
        alert.setTimes(Integer.valueOf(1));
        HashMap<String, String> tags = alert.getTags();
        if (tags == null) {
            tags = new HashMap<String, String>(8);
            alert.setTags(tags);
        }
        if ((monitorIdStr = (String)tags.get("monitorId")) == null) {
            log.debug("receiver extern alarm message: {}", (Object)alert);
        } else {
            long monitorId = Long.parseLong(monitorIdStr);
            List<Tag> tagList = this.alertMonitorDao.findMonitorIdBindTags(monitorId);
            for (Tag tag : tagList) {
                if (tags.containsKey(tag.getName())) continue;
                tags.put(tag.getName(), tag.getTagValue());
            }
        }
        if (this.alarmConvergeReduce.filterConverge(alert) && this.alarmSilenceReduce.filterSilence(alert)) {
            this.dataQueue.sendAlertsData(alert);
        }
    }

    public AlarmCommonReduce(AlarmSilenceReduce alarmSilenceReduce, AlarmConvergeReduce alarmConvergeReduce, CommonDataQueue dataQueue, AlertMonitorDao alertMonitorDao) {
        this.alarmSilenceReduce = alarmSilenceReduce;
        this.alarmConvergeReduce = alarmConvergeReduce;
        this.dataQueue = dataQueue;
        this.alertMonitorDao = alertMonitorDao;
    }
}

