/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import org.apache.hertzbeat.alert.service.AlertSilenceService;
import org.apache.hertzbeat.common.entity.alerter.AlertSilence;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Alert Silence API")
@RestController
@RequestMapping(path={"/api/alert/silence"}, produces={"application/json"})
public class AlertSilenceController {
    @Autowired
    private AlertSilenceService alertSilenceService;

    @PostMapping
    @Operation(summary="New Alarm Silence", description="Added an alarm Silence")
    public ResponseEntity<Message<Void>> addNewAlertSilence(@Valid @RequestBody AlertSilence alertSilence) {
        this.alertSilenceService.validate(alertSilence, false);
        this.alertSilenceService.addAlertSilence(alertSilence);
        return ResponseEntity.ok((Object)Message.success((String)"Add success"));
    }

    @PutMapping
    @Operation(summary="Modifying an Alarm Silence", description="Modify an existing alarm Silence")
    public ResponseEntity<Message<Void>> modifyAlertSilence(@Valid @RequestBody AlertSilence alertSilence) {
        this.alertSilenceService.validate(alertSilence, true);
        this.alertSilenceService.modifyAlertSilence(alertSilence);
        return ResponseEntity.ok((Object)Message.success((String)"Modify success"));
    }

    @GetMapping(path={"/{id}"})
    @Operation(summary="Querying Alarm Silence", description="You can obtain alarm Silence information based on the alarm Silence ID")
    public ResponseEntity<Message<AlertSilence>> getAlertSilence(@Parameter(description="Alarm Silence ID", example="6565463543") @PathVariable(value="id") long id) {
        AlertSilence alertSilence = this.alertSilenceService.getAlertSilence(id);
        if (alertSilence == null) {
            return ResponseEntity.ok((Object)Message.fail((byte)3, (String)"AlertSilence not exist."));
        }
        return ResponseEntity.ok((Object)Message.success((Object)alertSilence));
    }
}

