/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Date;
import java.util.Optional;
import org.apache.hertzbeat.alert.dto.CloudAlertReportAbstract;
import org.apache.hertzbeat.alert.dto.GeneralCloudAlertReport;
import org.apache.hertzbeat.alert.enums.CloudServiceAlarmInformationEnum;
import org.apache.hertzbeat.alert.service.AlertService;
import org.apache.hertzbeat.common.entity.dto.AlertReport;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Extern Alarm Manage API")
@RestController
@RequestMapping(path={"/api/alerts/report"}, produces={"application/json"})
public class AlertReportController {
    private static final Logger log = LoggerFactory.getLogger(AlertReportController.class);
    @Autowired
    private AlertService alertService;

    @PostMapping(value={"/{cloud}"})
    @Operation(summary="Interface for reporting external alarm information of cloud service")
    public ResponseEntity<Message<Void>> addNewAlertReportFromCloud(@PathVariable(value="cloud") String cloudServiceName, @RequestBody String alertReport) {
        CloudServiceAlarmInformationEnum cloudService = CloudServiceAlarmInformationEnum.getEnumFromCloudServiceName(cloudServiceName);
        AlertReport alert = null;
        if (cloudService != null) {
            try {
                CloudAlertReportAbstract cloudAlertReport = (CloudAlertReportAbstract)JsonUtil.fromJson((String)alertReport, cloudService.getCloudServiceAlarmInformationEntity());
                assert (cloudAlertReport != null);
                alert = AlertReport.builder().content(cloudAlertReport.getContent()).alertName(cloudAlertReport.getAlertName()).alertTime(cloudAlertReport.getAlertTime()).alertDuration(cloudAlertReport.getAlertDuration()).priority(cloudAlertReport.getPriority()).reportType(cloudAlertReport.getReportType()).labels(cloudAlertReport.getLabels()).annotations(cloudAlertReport.getAnnotations()).build();
            }
            catch (Exception e) {
                log.error("[alert report] parse cloud service alarm content failed! cloud service: {} conrent: {}", (Object)cloudService.name(), (Object)alertReport);
            }
        } else {
            alert = AlertReport.builder().content("error do not has cloud service api").alertName("/api/alerts/report/" + cloudServiceName).alertTime(new Date().getTime()).priority(Integer.valueOf(1)).reportType(Integer.valueOf(1)).build();
        }
        Optional.ofNullable(alert).ifPresent(alertReportPresent -> this.alertService.addNewAlertReport((AlertReport)alertReportPresent));
        return ResponseEntity.ok((Object)Message.success((String)"Add report success"));
    }

    @PostMapping
    @Operation(summary="Interface for reporting external and general alarm information", description="The interface is used to report external and general alarm information")
    public ResponseEntity<Message<Void>> addNewAlertReport(@RequestBody GeneralCloudAlertReport alertReport) {
        alertReport.refreshAlertTime();
        this.alertService.addNewAlertReport(alertReport);
        return ResponseEntity.ok((Object)Message.success((String)"Add report success"));
    }
}

