/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.hertzbeat.alert.service.AlertConvergeService;
import org.apache.hertzbeat.common.entity.alerter.AlertConverge;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Alert Converge Batch API")
@RestController
@RequestMapping(path={"/api/alert/converges"}, produces={"application/json"})
public class AlertConvergesController {
    @Autowired
    private AlertConvergeService alertConvergeService;

    @GetMapping
    @Operation(summary="Query the alarm converge list", description="You can obtain the list of alarm converge by querying filter items")
    public ResponseEntity<Message<Page<AlertConverge>>> getAlertConverges(@Parameter(description="Alarm Converge ID", example="6565463543") @RequestParam(required=false) List<Long> ids, @Parameter(description="Search Name", example="x") @RequestParam(required=false) String search, @Parameter(description="Sort field, default id", example="id") @RequestParam(defaultValue="id") String sort, @Parameter(description="Sort mode: asc: ascending, desc: descending", example="desc") @RequestParam(defaultValue="desc") String order, @Parameter(description="List current page", example="0") @RequestParam(defaultValue="0") int pageIndex, @Parameter(description="Number of list pages", example="8") @RequestParam(defaultValue="8") int pageSize) {
        Specification & Serializable specification = (Specification & Serializable)(root, query, criteriaBuilder) -> {
            ArrayList<Object> andList = new ArrayList<Object>();
            if (ids != null && !ids.isEmpty()) {
                CriteriaBuilder.In inPredicate = criteriaBuilder.in((Expression)root.get("id"));
                Iterator iterator = ids.iterator();
                while (iterator.hasNext()) {
                    long id = (Long)iterator.next();
                    inPredicate.value((Object)id);
                }
                andList.add(inPredicate);
            }
            if (StringUtils.hasText((String)search)) {
                Predicate predicate = criteriaBuilder.or(new Predicate[]{criteriaBuilder.like(criteriaBuilder.lower((Expression)root.get("name")), "%" + search.toLowerCase() + "%")});
                andList.add(predicate);
            }
            Predicate[] predicates = new Predicate[andList.size()];
            return criteriaBuilder.and(andList.toArray(predicates));
        };
        Sort sortExp = Sort.by((Sort.Order[])new Sort.Order[]{new Sort.Order(Sort.Direction.fromString((String)order), sort)});
        PageRequest pageRequest = PageRequest.of((int)pageIndex, (int)pageSize, (Sort)sortExp);
        Page<AlertConverge> alertConvergePage = this.alertConvergeService.getAlertConverges((Specification<AlertConverge>)specification, pageRequest);
        return ResponseEntity.ok((Object)Message.success(alertConvergePage));
    }

    @DeleteMapping
    @Operation(summary="Delete alarm converge in batches", description="Delete alarm converge in batches based on the alarm converge ID list")
    public ResponseEntity<Message<Void>> deleteAlertDefines(@Parameter(description="Alarm Converge IDs", example="6565463543") @RequestParam(required=false) List<Long> ids) {
        if (ids != null && !ids.isEmpty()) {
            this.alertConvergeService.deleteAlertConverges(new HashSet<Long>(ids));
        }
        return ResponseEntity.ok((Object)Message.success());
    }
}

