/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import org.apache.hertzbeat.alert.service.AlertConvergeService;
import org.apache.hertzbeat.common.entity.alerter.AlertConverge;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Alert Converge API")
@RestController
@RequestMapping(path={"/api/alert/converge"}, produces={"application/json"})
public class AlertConvergeController {
    @Autowired
    private AlertConvergeService alertConvergeService;

    @PostMapping
    @Operation(summary="New Alarm Converge", description="Added an alarm Converge")
    public ResponseEntity<Message<Void>> addNewAlertConverge(@Valid @RequestBody AlertConverge alertConverge) {
        this.alertConvergeService.validate(alertConverge, false);
        this.alertConvergeService.addAlertConverge(alertConverge);
        return ResponseEntity.ok((Object)Message.success((String)"Add success"));
    }

    @PutMapping
    @Operation(summary="Modifying an Alarm Converge", description="Modify an existing alarm Converge")
    public ResponseEntity<Message<Void>> modifyAlertConverge(@Valid @RequestBody AlertConverge alertConverge) {
        this.alertConvergeService.validate(alertConverge, true);
        this.alertConvergeService.modifyAlertConverge(alertConverge);
        return ResponseEntity.ok((Object)Message.success((String)"Modify success"));
    }

    @GetMapping(path={"/{id}"})
    @Operation(summary="Querying Alarm Converge", description="You can obtain alarm Converge information based on the alarm Converge ID")
    public ResponseEntity<Message<AlertConverge>> getAlertConverge(@Parameter(description="Alarm Converge ID", example="6565463543") @PathVariable(value="id") long id) {
        AlertConverge alertConverge = this.alertConvergeService.getAlertConverge(id);
        if (alertConverge == null) {
            return ResponseEntity.ok((Object)Message.fail((byte)3, (String)"AlertConverge not exist."));
        }
        return ResponseEntity.ok((Object)Message.success((Object)alertConverge));
    }
}

