/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AlerterWorkerPool {
    private static final Logger log = LoggerFactory.getLogger(AlerterWorkerPool.class);
    private ThreadPoolExecutor workerExecutor;

    public AlerterWorkerPool() {
        this.initWorkExecutor();
    }

    private void initWorkExecutor() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setUncaughtExceptionHandler((thread, throwable) -> {
            log.error("workerExecutor has uncaughtException.");
            log.error(throwable.getMessage(), throwable);
        }).setDaemon(true).setNameFormat("alerter-worker-%d").build();
        this.workerExecutor = new ThreadPoolExecutor(6, 10, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory, new ThreadPoolExecutor.AbortPolicy());
    }

    public void executeJob(Runnable runnable) throws RejectedExecutionException {
        this.workerExecutor.execute(runnable);
    }
}

