/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.bolts.kafka;

import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.heron.api.Config;
import org.apache.heron.api.bolt.BaseRichBolt;
import org.apache.heron.api.bolt.OutputCollector;
import org.apache.heron.api.topology.OutputFieldsDeclarer;
import org.apache.heron.api.topology.TopologyContext;
import org.apache.heron.api.tuple.Tuple;
import org.apache.heron.bolts.kafka.KafkaProducerFactory;
import org.apache.heron.bolts.kafka.TupleTransformer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.KafkaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaBolt<K, V>
extends BaseRichBolt {
    private static final long serialVersionUID = -3301619269473733618L;
    private static final Logger LOG = LoggerFactory.getLogger(KafkaBolt.class);
    private KafkaProducerFactory<K, V> kafkaProducerFactory;
    private TupleTransformer<K, V> tupleTransformer;
    private transient Producer<K, V> producer;
    private Config.TopologyReliabilityMode topologyReliabilityMode;
    private transient OutputCollector outputCollector;

    public KafkaBolt(KafkaProducerFactory<K, V> kafkaProducerFactory, TupleTransformer<K, V> tupleTransformer) {
        this.kafkaProducerFactory = kafkaProducerFactory;
        this.tupleTransformer = tupleTransformer;
    }

    public void prepare(Map<String, Object> heronConf, TopologyContext context, OutputCollector collector) {
        this.topologyReliabilityMode = Config.TopologyReliabilityMode.valueOf((String)heronConf.getOrDefault("topology.reliability.mode", Config.TopologyReliabilityMode.ATMOST_ONCE).toString());
        this.producer = this.kafkaProducerFactory.create();
        this.outputCollector = collector;
    }

    public void cleanup() {
        super.cleanup();
        if (this.producer != null) {
            this.producer.close();
        }
    }

    public void execute(Tuple input) {
        ProducerRecord producerRecord = new ProducerRecord(this.tupleTransformer.getTopicName(input), this.tupleTransformer.transformToKey(input), this.tupleTransformer.transformToValue(input));
        if (this.topologyReliabilityMode == Config.TopologyReliabilityMode.EFFECTIVELY_ONCE) {
            try {
                this.producer.send(producerRecord).get();
            }
            catch (InterruptedException e2) {
                LOG.error("interrupted while waiting for the record to be sent", (Throwable)e2);
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e3) {
                LOG.error("error has occurred when sending record to Kafka", (Throwable)e3);
                throw new KafkaException((Throwable)e3);
            }
        } else {
            this.producer.send(producerRecord, (recordMetadata, e) -> {
                if (e != null) {
                    LOG.error("error has occurred when sending record to Kafka", (Throwable)e);
                    if (this.topologyReliabilityMode == Config.TopologyReliabilityMode.ATLEAST_ONCE) {
                        this.outputCollector.fail(input);
                    }
                } else if (this.topologyReliabilityMode == Config.TopologyReliabilityMode.ATLEAST_ONCE) {
                    this.outputCollector.ack(input);
                }
            });
        }
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
    }
}

