/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.streamlet.impl.streamlets;

import java.util.Set;
import org.apache.heron.api.topology.TopologyBuilder;
import org.apache.heron.streamlet.KeyValue;
import org.apache.heron.streamlet.SerializableFunction;
import org.apache.heron.streamlet.StreamletReducers;
import org.apache.heron.streamlet.impl.StreamletBaseImpl;
import org.apache.heron.streamlet.impl.StreamletImpl;
import org.apache.heron.streamlet.impl.groupings.ReduceByKeyAndWindowCustomGrouping;
import org.apache.heron.streamlet.impl.operators.ReduceByKeyOperator;

public class CountByKeyStreamlet<R, K>
extends StreamletImpl<KeyValue<K, Long>> {
    private StreamletImpl<R> parent;
    private SerializableFunction<R, K> keyExtractor;

    public CountByKeyStreamlet(StreamletImpl<R> parent, SerializableFunction<R, K> keyExtractor) {
        this.parent = parent;
        this.keyExtractor = keyExtractor;
        this.setNumPartitions(parent.getNumPartitions());
    }

    @Override
    public boolean doBuild(TopologyBuilder bldr, Set<String> stageNames) {
        this.setDefaultNameIfNone(StreamletBaseImpl.StreamletNamePrefix.COUNT, stageNames);
        ReduceByKeyOperator bolt = new ReduceByKeyOperator(this.keyExtractor, x -> 1L, StreamletReducers::sum);
        bldr.setBolt(this.getName(), bolt, (Number)this.getNumPartitions()).customGrouping(this.parent.getName(), this.parent.getStreamId(), new ReduceByKeyAndWindowCustomGrouping<R, K>(this.keyExtractor));
        return true;
    }
}

