/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.simulator;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.heron.api.Config;
import org.apache.heron.api.HeronTopology;
import org.apache.heron.api.generated.TopologyAPI;
import org.apache.heron.api.utils.TopologyUtils;
import org.apache.heron.common.basics.ByteAmount;
import org.apache.heron.common.basics.SingletonRegistry;
import org.apache.heron.common.config.SystemConfig;
import org.apache.heron.common.config.SystemConfigKey;
import org.apache.heron.proto.system.PhysicalPlans;
import org.apache.heron.simulator.executors.InstanceExecutor;
import org.apache.heron.simulator.executors.MetricsExecutor;
import org.apache.heron.simulator.executors.StreamExecutor;
import org.apache.heron.simulator.utils.TopologyManager;

public class Simulator {
    private static final Logger LOG = Logger.getLogger(Simulator.class.getName());
    private final List<InstanceExecutor> instanceExecutors = new LinkedList<InstanceExecutor>();
    private final ExecutorService threadsPool = Executors.newCachedThreadPool();
    private SystemConfig systemConfig;
    private StreamExecutor streamExecutor;
    private MetricsExecutor metricsExecutor;

    public Simulator() {
        this(true);
    }

    public Simulator(boolean initialize) {
        if (initialize) {
            this.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        this.systemConfig = this.getSystemConfig();
        SingletonRegistry singletonRegistry = SingletonRegistry.INSTANCE;
        synchronized (singletonRegistry) {
            if (!this.isSystemConfigExisted()) {
                LOG.info("System config not existed. Registering...");
                this.registerSystemConfig(this.systemConfig);
                LOG.info("System config registered.");
            } else {
                LOG.info("System config already existed.");
            }
        }
    }

    protected boolean isSystemConfigExisted() {
        return SingletonRegistry.INSTANCE.containsSingleton(SystemConfig.HERON_SYSTEM_CONFIG);
    }

    protected void registerSystemConfig(SystemConfig sysConfig) {
        SingletonRegistry.INSTANCE.registerSingleton(SystemConfig.HERON_SYSTEM_CONFIG, sysConfig);
    }

    public void submitTopology(String name, Config heronConfig, HeronTopology heronTopology) {
        TopologyAPI.Topology topologyToRun = heronTopology.setConfig(heronConfig).setName(name).setState(TopologyAPI.TopologyState.RUNNING).getTopology();
        if (!TopologyUtils.verifyTopology(topologyToRun)) {
            throw new RuntimeException("Topology object is Malformed");
        }
        if (this.isTopologyStateful(heronConfig)) {
            throw new RuntimeException("Stateful topology is not supported");
        }
        TopologyManager topologyManager = new TopologyManager(topologyToRun);
        LOG.info("Physical Plan: \n" + topologyManager.getPhysicalPlan());
        this.streamExecutor = new StreamExecutor(topologyManager);
        this.metricsExecutor = new MetricsExecutor(this.systemConfig);
        for (PhysicalPlans.Instance instance : topologyManager.getPhysicalPlan().getInstancesList()) {
            InstanceExecutor instanceExecutor = new InstanceExecutor(topologyManager.getPhysicalPlan(), instance.getInstanceId());
            this.streamExecutor.addInstanceExecutor(instanceExecutor);
            this.metricsExecutor.addInstanceExecutor(instanceExecutor);
            this.instanceExecutors.add(instanceExecutor);
        }
        Thread.setDefaultUncaughtExceptionHandler(new DefaultExceptionHandler());
        this.threadsPool.execute(this.metricsExecutor);
        this.threadsPool.execute(this.streamExecutor);
        for (InstanceExecutor instanceExecutor : this.instanceExecutors) {
            this.threadsPool.execute(instanceExecutor);
        }
    }

    public void killTopology(String topologyName) {
        LOG.info("To kill topology: " + topologyName);
        this.stop();
        LOG.info("Topology killed successfully");
    }

    public void activate(String topologyName) {
        LOG.info("To activate topology: " + topologyName);
        for (InstanceExecutor executor : this.instanceExecutors) {
            executor.activate();
        }
        LOG.info("Activated topology: " + topologyName);
    }

    public void deactivate(String topologyName) {
        LOG.info("To deactivate topology: " + topologyName);
        for (InstanceExecutor executor : this.instanceExecutors) {
            executor.deactivate();
        }
        LOG.info("Deactivated topology:" + topologyName);
    }

    public void shutdown() {
        LOG.info("To shutdown thread pool");
        if (this.threadsPool.isShutdown()) {
            this.threadsPool.shutdownNow();
        }
        LOG.info("Heron simulator exited.");
    }

    public void stop() {
        for (InstanceExecutor executor : this.instanceExecutors) {
            executor.stop();
        }
        LOG.info("To stop Stream Executor");
        this.streamExecutor.stop();
        LOG.info("To stop Metrics Executor");
        this.metricsExecutor.stop();
        this.threadsPool.shutdown();
    }

    protected SystemConfig getSystemConfig() {
        SystemConfig.Builder builder = SystemConfig.newBuilder(true).put(SystemConfigKey.INSTANCE_SET_DATA_TUPLE_CAPACITY, 256).put(SystemConfigKey.INSTANCE_SET_CONTROL_TUPLE_CAPACITY, 256).put(SystemConfigKey.HERON_METRICS_EXPORT_INTERVAL, 60).put(SystemConfigKey.INSTANCE_EXECUTE_BATCH_TIME, 16).put(SystemConfigKey.INSTANCE_EXECUTE_BATCH_SIZE, ByteAmount.fromBytes(32768L)).put(SystemConfigKey.INSTANCE_EMIT_BATCH_TIME, 16).put(SystemConfigKey.INSTANCE_EMIT_BATCH_SIZE, ByteAmount.fromBytes(32768L)).put(SystemConfigKey.INSTANCE_ACK_BATCH_TIME, 128).put(SystemConfigKey.INSTANCE_ACKNOWLEDGEMENT_NBUCKETS, 10);
        return builder.build();
    }

    private boolean isTopologyStateful(Config heronConfig) {
        Config.TopologyReliabilityMode mode = Config.TopologyReliabilityMode.valueOf(String.valueOf(heronConfig.get("topology.reliability.mode")));
        return Config.TopologyReliabilityMode.EFFECTIVELY_ONCE.equals((Object)mode);
    }

    public class DefaultExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        @Override
        public void uncaughtException(Thread thread, Throwable exception) {
            try {
                this.handleException(thread, exception);
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Failed to handle exception. Process halting", t);
                Runtime.getRuntime().halt(1);
            }
        }

        private void handleException(Thread thread, Throwable exception) {
            LOG.severe("Local Mode Process exiting.");
            LOG.log(Level.SEVERE, "Exception caught in thread: " + thread.getName() + " with id: " + thread.getId(), exception);
            for (Handler handler : Logger.getLogger("").getHandlers()) {
                handler.close();
            }
            Simulator.this.threadsPool.shutdownNow();
            Runtime.getRuntime().halt(1);
        }
    }
}

