/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.network;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.heron.common.basics.Communicator;
import org.apache.heron.common.basics.NIOLooper;
import org.apache.heron.common.basics.SingletonRegistry;
import org.apache.heron.common.config.SystemConfig;
import org.apache.heron.common.network.HeronClient;
import org.apache.heron.common.network.HeronSocketOptions;
import org.apache.heron.common.network.StatusCode;
import org.apache.heron.metrics.GatewayMetrics;
import org.apache.heron.proto.system.Common;
import org.apache.heron.proto.system.Metrics;
import org.apache.heron.proto.system.PhysicalPlans;
import org.apache.heron.shaded.com.google.protobuf.Message;

public class MetricsManagerClient
extends HeronClient {
    private static final Logger LOG = Logger.getLogger(MetricsManagerClient.class.getName());
    private final PhysicalPlans.Instance instance;
    private final List<Communicator<Metrics.MetricPublisherPublishMessage>> outMetricsQueues;
    private final SystemConfig systemConfig;
    private final GatewayMetrics gatewayMetrics;
    private String hostname;

    public MetricsManagerClient(NIOLooper s, String metricsHost, int metricsPort, PhysicalPlans.Instance instance, List<Communicator<Metrics.MetricPublisherPublishMessage>> outs, HeronSocketOptions options, GatewayMetrics gatewayMetrics) {
        super(s, metricsHost, metricsPort, options);
        this.instance = instance;
        this.outMetricsQueues = outs;
        this.systemConfig = (SystemConfig)SingletonRegistry.INSTANCE.getSingleton(SystemConfig.HERON_SYSTEM_CONFIG);
        this.gatewayMetrics = gatewayMetrics;
        this.addMetricsManagerClientTasksOnWakeUp();
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("GetHostName failed");
        }
    }

    private void addMetricsManagerClientTasksOnWakeUp() {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                MetricsManagerClient.this.sendMetricsMessageIfNeeded();
            }
        };
        this.getNIOLooper().addTasksOnWakeup(task);
    }

    private void sendMetricsMessageIfNeeded() {
        if (this.isConnected()) {
            for (Communicator<Metrics.MetricPublisherPublishMessage> c : this.outMetricsQueues) {
                while (!c.isEmpty()) {
                    Metrics.MetricPublisherPublishMessage m = c.poll();
                    this.gatewayMetrics.updateSentMetricsSize(m.getSerializedSize());
                    this.gatewayMetrics.updateSentMetrics(m.getMetricsCount(), m.getExceptionsCount());
                    this.sendMessage(m);
                }
            }
        }
    }

    public void sendAllMessage() {
        if (!this.isConnected()) {
            return;
        }
        LOG.info("Flushing all pending data in MetricsManagerClient");
        for (Communicator<Metrics.MetricPublisherPublishMessage> c : this.outMetricsQueues) {
            int size = c.size();
            for (int i = 0; i < size; ++i) {
                Metrics.MetricPublisherPublishMessage m = c.poll();
                this.sendMessage(m);
            }
        }
    }

    @Override
    public void onError() {
        LOG.severe("Disconnected from Metrics Manager.");
        this.onConnect(StatusCode.CONNECT_ERROR);
    }

    @Override
    public void onConnect(StatusCode status) {
        if (status != StatusCode.OK) {
            LOG.log(Level.WARNING, "Cannot connect to the metrics port with status: {0}, Will Retry..", (Object)status);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    MetricsManagerClient.this.start();
                }
            };
            this.getNIOLooper().registerTimerEvent(this.systemConfig.getInstanceReconnectMetricsmgrInterval(), r);
            return;
        }
        LOG.info("Connected to Metrics Manager. Ready to send register request");
        this.sendRegisterRequest();
    }

    private void sendRegisterRequest() {
        Metrics.MetricPublisher publisher = Metrics.MetricPublisher.newBuilder().setHostname(this.hostname).setPort(this.instance.getInfo().getTaskId()).setComponentName(this.instance.getInfo().getComponentName()).setInstanceId(this.instance.getInstanceId()).setInstanceIndex(this.instance.getInfo().getComponentIndex()).build();
        Metrics.MetricPublisherRegisterRequest request = Metrics.MetricPublisherRegisterRequest.newBuilder().setPublisher(publisher).build();
        this.sendRequest(request, null, Metrics.MetricPublisherRegisterResponse.newBuilder(), this.systemConfig.getInstanceReconnectMetricsmgrInterval());
    }

    @Override
    public void onResponse(StatusCode status, Object ctx, Message response) {
        if (status != StatusCode.OK) {
            throw new RuntimeException("Response from Metrics Manager not ok");
        }
        if (!Metrics.MetricPublisherRegisterResponse.class.isInstance(response)) {
            throw new RuntimeException("Unknown kind of response received from Metrics Manager");
        }
        this.handleRegisterResponse((Metrics.MetricPublisherRegisterResponse)response);
    }

    @Override
    public void onIncomingMessage(Message message) {
        throw new RuntimeException("MetricsClient got an unknown message from Metrics Manager");
    }

    @Override
    public void onClose() {
        LOG.info("MetricsManagerClient exits");
    }

    private void handleRegisterResponse(Metrics.MetricPublisherRegisterResponse response) {
        if (response.getStatus().getStatus() != Common.StatusCode.OK) {
            throw new RuntimeException("Metrics Manager returned a not ok response for register");
        }
        LOG.info("We registered ourselves to the Metrics Manager");
    }
}

