/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.common.utils.misc;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.apache.heron.api.Config;
import org.apache.heron.api.generated.TopologyAPI;
import org.apache.heron.api.grouping.CustomStreamGrouping;
import org.apache.heron.api.utils.Utils;
import org.apache.heron.common.utils.metrics.MetricsCollector;
import org.apache.heron.common.utils.misc.CustomStreamGroupingHelper;
import org.apache.heron.common.utils.topology.TopologyContextImpl;
import org.apache.heron.proto.system.PhysicalPlans;

public class PhysicalPlanHelper {
    private static final Logger LOG = Logger.getLogger(PhysicalPlanHelper.class.getName());
    private final PhysicalPlans.PhysicalPlan pplan;
    private final int myTaskId;
    private final String myComponent;
    private final String hostname;
    private final String myInstanceId;
    private final TopologyAPI.Component component;
    private final Map<String, Integer> outputSchema;
    private final CustomStreamGroupingHelper customGrouper;
    private PhysicalPlans.Instance myInstance;
    private TopologyAPI.Spout mySpout;
    private TopologyAPI.Bolt myBolt;
    private TopologyContextImpl topologyContext;
    private final boolean isTerminatedComponent;

    public PhysicalPlanHelper(PhysicalPlans.PhysicalPlan pplan, String instanceId) {
        List<TopologyAPI.OutputStream> outputs;
        int i;
        this.pplan = pplan;
        for (int i2 = 0; i2 < pplan.getInstancesCount(); ++i2) {
            if (!pplan.getInstances(i2).getInstanceId().equals(instanceId)) continue;
            this.myInstance = pplan.getInstances(i2);
        }
        if (this.myInstance == null) {
            throw new RuntimeException("There was no instance that matched my id " + instanceId);
        }
        this.myComponent = this.myInstance.getInfo().getComponentName();
        this.myTaskId = this.myInstance.getInfo().getTaskId();
        this.myInstanceId = this.myInstance.getInstanceId();
        TopologyAPI.Topology topo = pplan.getTopology();
        for (i = 0; i < topo.getSpoutsCount(); ++i) {
            if (!topo.getSpouts(i).getComp().getName().equals(this.myComponent)) continue;
            this.mySpout = topo.getSpouts(i);
            break;
        }
        for (i = 0; i < topo.getBoltsCount(); ++i) {
            if (!topo.getBolts(i).getComp().getName().equals(this.myComponent)) continue;
            this.myBolt = topo.getBolts(i);
            break;
        }
        if (this.mySpout != null && this.myBolt != null) {
            throw new RuntimeException("MyTaskId is both a bolt or a spout " + this.myTaskId);
        }
        if (this.mySpout == null && this.myBolt == null) {
            throw new RuntimeException("MyTaskId is neither a bolt or a spout " + this.myTaskId);
        }
        this.outputSchema = new ConcurrentHashMap<String, Integer>();
        if (this.mySpout != null) {
            outputs = this.mySpout.getOutputsList();
            this.component = this.mySpout.getComp();
        } else {
            outputs = this.myBolt.getOutputsList();
            this.component = this.myBolt.getComp();
        }
        for (TopologyAPI.OutputStream outputStream : outputs) {
            this.outputSchema.put(outputStream.getStream().getId(), outputStream.getSchema().getKeysCount());
        }
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("GetHostName failed");
        }
        this.customGrouper = new CustomStreamGroupingHelper();
        for (int i3 = 0; i3 < topo.getBoltsCount(); ++i3) {
            for (TopologyAPI.InputStream inputStream : topo.getBolts(i3).getInputsList()) {
                if (!inputStream.getStream().getComponentName().equals(this.myComponent) || inputStream.getGtype() != TopologyAPI.Grouping.CUSTOM) continue;
                CustomStreamGrouping customStreamGrouping = (CustomStreamGrouping)Utils.deserialize(inputStream.getCustomGroupingObject().toByteArray());
                this.customGrouper.add(inputStream.getStream().getId(), this.getTaskIdsAsListForComponent(topo.getBolts(i3).getComp().getName()), customStreamGrouping, this.myComponent);
            }
        }
        HashSet<String> terminals = this.getTerminatedComponentSet();
        this.isTerminatedComponent = terminals.contains(this.myComponent);
    }

    public void checkOutputSchema(String streamId, List<Object> tuple) {
        Integer size = this.outputSchema.get(streamId);
        if (size == null) {
            throw new RuntimeException(this.myComponent + " emitting stream " + streamId + " but was not declared in declareOutputFields");
        }
        if (!size.equals(tuple.size())) {
            throw new RuntimeException("Number of fields emitted in stream " + streamId + " does not match whats expected. Expected " + Integer.toString(size) + " Observed " + Integer.toString(tuple.size()));
        }
    }

    public TopologyAPI.TopologyState getTopologyState() {
        return this.pplan.getTopology().getState();
    }

    public int getMyTaskId() {
        return this.myTaskId;
    }

    public String getMyHostname() {
        return this.hostname;
    }

    public String getMyInstanceId() {
        return this.myInstanceId;
    }

    public int getMyInstanceIndex() {
        return this.myInstance.getInfo().getComponentIndex();
    }

    public String getMyComponent() {
        return this.myComponent;
    }

    public TopologyAPI.Spout getMySpout() {
        return this.mySpout;
    }

    public TopologyAPI.Bolt getMyBolt() {
        return this.myBolt;
    }

    public TopologyContextImpl getTopologyContext() {
        return this.topologyContext;
    }

    public void setTopologyContext(MetricsCollector metricsCollector) {
        this.topologyContext = new TopologyContextImpl(this.mergeConfigs(this.pplan.getTopology().getTopologyConfig(), this.component), this.pplan.getTopology(), this.makeTaskToComponentMap(), this.myTaskId, metricsCollector);
    }

    private Map<String, Object> mergeConfigs(TopologyAPI.Config config, TopologyAPI.Component acomponent) {
        LOG.info("Building configs for component: " + this.myComponent);
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.addConfigsToMap(config, map);
        LOG.info("Added topology-level configs: " + ((Object)map).toString());
        this.addConfigsToMap(acomponent.getConfig(), map);
        LOG.info("Added component-specific configs: " + ((Object)map).toString());
        return map;
    }

    private void addConfigsToMap(TopologyAPI.Config config, Map<String, Object> map) {
        for (TopologyAPI.Config.KeyValue kv : config.getKvsList()) {
            if (kv.hasValue()) {
                map.put(kv.getKey(), kv.getValue());
                continue;
            }
            map.put(kv.getKey(), Utils.deserialize(kv.getSerializedValue().toByteArray()));
        }
    }

    private Map<Integer, String> makeTaskToComponentMap() {
        HashMap<Integer, String> retval = new HashMap<Integer, String>();
        for (PhysicalPlans.Instance instance : this.pplan.getInstancesList()) {
            retval.put(instance.getInfo().getTaskId(), instance.getInfo().getComponentName());
        }
        return retval;
    }

    private List<Integer> getTaskIdsAsListForComponent(String comp) {
        LinkedList<Integer> retval = new LinkedList<Integer>();
        for (PhysicalPlans.Instance instance : this.pplan.getInstancesList()) {
            if (!instance.getInfo().getComponentName().equals(comp)) continue;
            retval.add(instance.getInfo().getTaskId());
        }
        return retval;
    }

    public void prepareForCustomStreamGrouping() {
        this.customGrouper.prepare(this.topologyContext);
    }

    public List<Integer> chooseTasksForCustomStreamGrouping(String streamId, List<Object> values) {
        return this.customGrouper.chooseTasks(streamId, values);
    }

    public boolean isTerminatedComponent() {
        return this.isTerminatedComponent;
    }

    private HashSet<String> getTerminatedComponentSet() {
        String name;
        HashMap<String, TopologyAPI.Spout> spouts = new HashMap<String, TopologyAPI.Spout>();
        HashMap prev = new HashMap();
        for (TopologyAPI.Spout spout : this.pplan.getTopology().getSpoutsList()) {
            name = spout.getComp().getName();
            spouts.put(name, spout);
        }
        for (TopologyAPI.Bolt bolt : this.pplan.getTopology().getBoltsList()) {
            name = bolt.getComp().getName();
            for (TopologyAPI.InputStream inputStream : bolt.getInputsList()) {
                String parent = inputStream.getStream().getComponentName();
                if (prev.containsKey(name)) {
                    ((HashSet)prev.get(name)).add(parent);
                    continue;
                }
                HashSet<String> parents = new HashSet<String>();
                parents.add(parent);
                prev.put(name, parents);
            }
        }
        HashSet<String> terminals = new HashSet<String>();
        HashSet nonTerminals = new HashSet();
        for (HashSet set : prev.values()) {
            nonTerminals.addAll(set);
        }
        for (String bolt : prev.keySet()) {
            if (nonTerminals.contains(bolt)) continue;
            terminals.add(bolt);
        }
        for (String spout : spouts.keySet()) {
            if (nonTerminals.contains(spout)) continue;
            terminals.add(spout);
        }
        return terminals;
    }

    public boolean isCustomGroupingEmpty() {
        return this.customGrouper.isCustomGroupingEmpty();
    }

    public boolean isTopologyStateful() {
        Map<String, Object> config = this.topologyContext.getTopologyConfig();
        if (config.get("topology.reliability.mode") == null) {
            return false;
        }
        Config.TopologyReliabilityMode mode = Config.TopologyReliabilityMode.valueOf(String.valueOf(config.get("topology.reliability.mode")));
        return Config.TopologyReliabilityMode.EFFECTIVELY_ONCE.equals((Object)mode);
    }

    public boolean isTopologyRunning() {
        return this.getTopologyState().equals(TopologyAPI.TopologyState.RUNNING);
    }
}

