/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.classification;

import java.util.Set;
import org.apache.heron.shaded.javax.annotation.processing.AbstractProcessor;
import org.apache.heron.shaded.javax.annotation.processing.ProcessingEnvironment;
import org.apache.heron.shaded.javax.annotation.processing.RoundEnvironment;
import org.apache.heron.shaded.javax.annotation.processing.SupportedAnnotationTypes;
import org.apache.heron.shaded.javax.annotation.processing.SupportedSourceVersion;
import org.apache.heron.shaded.javax.lang.model.SourceVersion;
import org.apache.heron.shaded.javax.lang.model.element.Element;
import org.apache.heron.shaded.javax.lang.model.element.TypeElement;
import org.apache.heron.shaded.javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"org.apache.heron.classification.InterfaceStability.Unstable", "org.apache.heron.classification.InterfaceAudience.Private", "org.apache.heron.classification.InterfaceAudience.LimitedPrivate"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_11)
public class HeronAnnotationProcessor
extends AbstractProcessor {
    private ProcessingEnvironment env;

    public synchronized void init(ProcessingEnvironment pe) {
        this.env = pe;
    }

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            for (TypeElement typeElement : annotations) {
                for (Element elt : roundEnv.getElementsAnnotatedWith(typeElement)) {
                    if (elt.toString().startsWith("org.apache.heron")) continue;
                    this.env.getMessager().printMessage(Diagnostic.Kind.WARNING, (CharSequence)String.format("%s extends from a class annotated with %s", elt, typeElement), elt);
                }
            }
        }
        return true;
    }
}

