/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.spouts.kafka;

import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.heron.api.Config;
import org.apache.heron.api.spout.BaseRichSpout;
import org.apache.heron.api.spout.SpoutOutputCollector;
import org.apache.heron.api.state.State;
import org.apache.heron.api.topology.IStatefulComponent;
import org.apache.heron.api.topology.OutputFieldsDeclarer;
import org.apache.heron.api.topology.TopologyContext;
import org.apache.heron.api.tuple.Fields;
import org.apache.heron.common.basics.SingletonRegistry;
import org.apache.heron.common.config.SystemConfig;
import org.apache.heron.spouts.kafka.ConsumerRecordTransformer;
import org.apache.heron.spouts.kafka.DefaultConsumerRecordTransformer;
import org.apache.heron.spouts.kafka.KafkaConsumerFactory;
import org.apache.heron.spouts.kafka.KafkaMetricDecorator;
import org.apache.heron.spouts.kafka.TopicPatternProvider;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaSpout<K, V>
extends BaseRichSpout
implements IStatefulComponent<TopicPartition, Long> {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaSpout.class);
    private static final long serialVersionUID = -2271355516537883361L;
    private int metricsIntervalInSecs = 60;
    private KafkaConsumerFactory<K, V> kafkaConsumerFactory;
    private TopicPatternProvider topicPatternProvider;
    private Collection<String> topicNames;
    private ConsumerRecordTransformer<K, V> consumerRecordTransformer = new DefaultConsumerRecordTransformer();
    private transient SpoutOutputCollector collector;
    private transient TopologyContext topologyContext;
    private transient Queue<ConsumerRecord<K, V>> buffer;
    private transient Consumer<K, V> consumer;
    private transient Set<MetricName> reportedMetrics;
    private transient Set<TopicPartition> assignedPartitions;
    private transient Map<TopicPartition, NavigableMap<Long, Long>> ackRegistry;
    private transient Map<TopicPartition, Long> failureRegistry;
    private Config.TopologyReliabilityMode topologyReliabilityMode = Config.TopologyReliabilityMode.ATMOST_ONCE;
    private long previousKafkaMetricsUpdatedTimestamp = 0L;
    private State<TopicPartition, Long> state;

    public KafkaSpout(KafkaConsumerFactory<K, V> kafkaConsumerFactory, Collection<String> topicNames) {
        this.kafkaConsumerFactory = kafkaConsumerFactory;
        this.topicNames = topicNames;
    }

    public KafkaSpout(KafkaConsumerFactory<K, V> kafkaConsumerFactory, TopicPatternProvider topicPatternProvider) {
        this.kafkaConsumerFactory = kafkaConsumerFactory;
        this.topicPatternProvider = topicPatternProvider;
    }

    public ConsumerRecordTransformer<K, V> getConsumerRecordTransformer() {
        return this.consumerRecordTransformer;
    }

    public void setConsumerRecordTransformer(ConsumerRecordTransformer<K, V> consumerRecordTransformer) {
        this.consumerRecordTransformer = consumerRecordTransformer;
    }

    public void open(Map<String, Object> conf, TopologyContext context, SpoutOutputCollector aCollector) {
        this.collector = aCollector;
        this.topologyContext = context;
        this.initialize(conf);
    }

    public void initState(State<TopicPartition, Long> aState) {
        this.state = aState;
        LOG.info("initial state {}", aState);
    }

    public void preSave(String checkpointId) {
        LOG.info("save state {}", this.state);
        this.consumer.commitAsync(this.state.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new OffsetAndMetadata((Long)entry.getValue() + 1L))), null);
    }

    public void nextTuple() {
        ConsumerRecord<K, V> record = this.buffer.poll();
        if (record != null) {
            this.emitConsumerRecord(record);
        } else {
            if (this.topologyReliabilityMode == Config.TopologyReliabilityMode.ATLEAST_ONCE) {
                this.ackRegistry.forEach((key, value) -> {
                    if (value != null) {
                        this.rewindAndDiscardAck((TopicPartition)key, (NavigableMap<Long, Long>)value);
                        this.manualCommit((TopicPartition)key, (NavigableMap<Long, Long>)value);
                    }
                });
            }
            this.poll().forEach(kvConsumerRecord -> this.buffer.offer((ConsumerRecord<K, V>)kvConsumerRecord));
        }
    }

    public void activate() {
        if (!this.assignedPartitions.isEmpty()) {
            this.consumer.resume(this.assignedPartitions);
        }
    }

    public void deactivate() {
        if (!this.assignedPartitions.isEmpty()) {
            this.consumer.pause(this.assignedPartitions);
        }
    }

    public void ack(Object msgId) {
        long ceilingTop;
        long start = System.nanoTime();
        ConsumerRecordMessageId consumerRecordMessageId = (ConsumerRecordMessageId)msgId;
        TopicPartition topicPartition = consumerRecordMessageId.getTopicPartition();
        if (!this.assignedPartitions.contains(topicPartition)) {
            LOG.info("ignore {} because it's been revoked", (Object)consumerRecordMessageId);
            return;
        }
        long offset = consumerRecordMessageId.getOffset();
        this.ackRegistry.putIfAbsent(topicPartition, new TreeMap());
        NavigableMap<Long, Long> navigableMap = this.ackRegistry.get(topicPartition);
        Map.Entry<Long, Long> floorRange = navigableMap.floorEntry(offset);
        Map.Entry<Long, Long> ceilingRange = navigableMap.ceilingEntry(offset);
        long floorBottom = floorRange != null ? floorRange.getKey() : Long.MIN_VALUE;
        long floorTop = floorRange != null ? floorRange.getValue() : Long.MIN_VALUE;
        long ceilingBottom = ceilingRange != null ? ceilingRange.getKey() : Long.MAX_VALUE;
        long l = ceilingTop = ceilingRange != null ? ceilingRange.getValue() : Long.MAX_VALUE;
        if (offset >= floorBottom && offset <= floorTop || offset >= ceilingBottom && offset <= ceilingTop) {
            return;
        }
        if (ceilingBottom - floorTop == 2L) {
            navigableMap.put(floorBottom, ceilingTop);
            navigableMap.remove(ceilingBottom);
        } else if (offset == floorTop + 1L) {
            navigableMap.put(floorBottom, offset);
        } else if (offset == ceilingBottom - 1L) {
            navigableMap.remove(ceilingBottom);
            navigableMap.put(offset, ceilingTop);
        } else {
            navigableMap.put(offset, offset);
        }
        LOG.debug("ack {} in {} ns", msgId, (Object)(System.nanoTime() - start));
        LOG.debug("{}", this.ackRegistry.get(consumerRecordMessageId.getTopicPartition()));
    }

    public void fail(Object msgId) {
        ConsumerRecordMessageId consumerRecordMessageId = (ConsumerRecordMessageId)msgId;
        TopicPartition topicPartition = consumerRecordMessageId.getTopicPartition();
        if (!this.assignedPartitions.contains(topicPartition)) {
            LOG.info("ignore {} because it's been revoked", (Object)consumerRecordMessageId);
            return;
        }
        long offset = consumerRecordMessageId.getOffset();
        this.failureRegistry.put(topicPartition, Math.min(this.failureRegistry.getOrDefault(topicPartition, Long.MAX_VALUE), offset));
        LOG.warn("fail {}", msgId);
    }

    public void close() {
        this.consumer.close();
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        this.consumerRecordTransformer.getOutputStreams().forEach(s -> declarer.declareStream(s, new Fields(this.consumerRecordTransformer.getFieldNames((String)s))));
    }

    public Map<String, Object> getComponentConfiguration() {
        return null;
    }

    private void initialize(Map<String, Object> conf) {
        this.topologyReliabilityMode = Config.TopologyReliabilityMode.valueOf((String)conf.get("topology.reliability.mode").toString());
        this.metricsIntervalInSecs = (int)((SystemConfig)SingletonRegistry.INSTANCE.getSingleton(SystemConfig.HERON_SYSTEM_CONFIG)).getHeronMetricsExportInterval().getSeconds();
        this.consumer = this.kafkaConsumerFactory.create();
        if (this.topicNames != null) {
            this.consumer.subscribe(this.topicNames, (ConsumerRebalanceListener)new KafkaConsumerRebalanceListener());
        } else {
            this.consumer.subscribe(this.topicPatternProvider.create(), (ConsumerRebalanceListener)new KafkaConsumerRebalanceListener());
        }
        this.buffer = new ArrayDeque<ConsumerRecord<K, V>>(500);
        this.ackRegistry = new HashMap<TopicPartition, NavigableMap<Long, Long>>();
        this.failureRegistry = new HashMap<TopicPartition, Long>();
        this.assignedPartitions = new HashSet<TopicPartition>();
        this.reportedMetrics = new HashSet<MetricName>();
    }

    private void emitConsumerRecord(ConsumerRecord<K, V> record) {
        Map<String, List<Object>> tupleByStream = this.consumerRecordTransformer.transform(record);
        if (tupleByStream.isEmpty() && this.topologyReliabilityMode == Config.TopologyReliabilityMode.ATLEAST_ONCE) {
            this.ack(new ConsumerRecordMessageId(new TopicPartition(record.topic(), record.partition()), record.offset()));
            return;
        }
        tupleByStream.forEach((s, objects) -> {
            switch (this.topologyReliabilityMode) {
                case ATMOST_ONCE: {
                    this.collector.emit(s, objects);
                    break;
                }
                case ATLEAST_ONCE: {
                    ConsumerRecordMessageId consumerRecordMessageId = new ConsumerRecordMessageId(new TopicPartition(record.topic(), record.partition()), record.offset());
                    this.collector.emit(s, objects, (Object)consumerRecordMessageId);
                    break;
                }
                case EFFECTIVELY_ONCE: {
                    this.collector.emit(s, objects);
                    this.state.put((Object)new TopicPartition(record.topic(), record.partition()), (Object)record.offset());
                    break;
                }
                default: {
                    LOG.warn("unsupported reliability mode {}", (Object)this.topologyReliabilityMode);
                }
            }
        });
    }

    private void rewindAndDiscardAck(TopicPartition topicPartition, NavigableMap<Long, Long> ackRanges) {
        if (this.failureRegistry.containsKey(topicPartition)) {
            long earliestFailedOffset = this.failureRegistry.get(topicPartition);
            this.consumer.seek(topicPartition, earliestFailedOffset);
            SortedMap<Long, Long> sortedMap = ackRanges.headMap(earliestFailedOffset);
            if (!sortedMap.isEmpty()) {
                sortedMap.put(sortedMap.lastKey(), Math.min(earliestFailedOffset, (Long)sortedMap.get(sortedMap.lastKey())));
            }
            this.ackRegistry.put(topicPartition, new TreeMap<Long, Long>(sortedMap));
            this.failureRegistry.remove(topicPartition);
        }
    }

    private void manualCommit(TopicPartition topicPartition, NavigableMap<Long, Long> ackRanges) {
        Map.Entry<Long, Long> firstEntry = ackRanges.firstEntry();
        if (firstEntry != null) {
            this.consumer.commitAsync(Collections.singletonMap(topicPartition, new OffsetAndMetadata(firstEntry.getValue() + 1L)), null);
        }
    }

    private Iterable<ConsumerRecord<K, V>> poll() {
        ConsumerRecords records = this.consumer.poll(Duration.ofMillis(200L));
        if (!records.isEmpty()) {
            if (System.currentTimeMillis() - this.previousKafkaMetricsUpdatedTimestamp > (long)(this.metricsIntervalInSecs * 1000)) {
                this.registerConsumerMetrics();
                this.previousKafkaMetricsUpdatedTimestamp = System.currentTimeMillis();
            }
            if (this.topologyReliabilityMode == Config.TopologyReliabilityMode.ATMOST_ONCE) {
                this.consumer.commitAsync();
            }
            return records;
        }
        return Collections.emptyList();
    }

    private void registerConsumerMetrics() {
        this.consumer.metrics().forEach((metricName, o) -> {
            if (!this.reportedMetrics.contains(metricName)) {
                this.reportedMetrics.add((MetricName)metricName);
                String exposedName = this.extractKafkaMetricName((MetricName)metricName);
                LOG.info("register Kakfa Consumer metric {}", (Object)exposedName);
                this.topologyContext.registerMetric(exposedName, new KafkaMetricDecorator<Metric>((Metric)o), this.metricsIntervalInSecs);
            }
        });
    }

    private String extractKafkaMetricName(MetricName metricName) {
        StringBuilder builder = new StringBuilder().append(metricName.name()).append('-').append(metricName.group());
        metricName.tags().forEach((s, s2) -> builder.append('-').append((String)s).append('-').append((String)s2));
        LOG.info("register Kakfa Consumer metric {}", (Object)builder);
        return builder.toString();
    }

    public class KafkaConsumerRebalanceListener
    implements ConsumerRebalanceListener {
        public void onPartitionsRevoked(Collection<TopicPartition> collection) {
            LOG.info("revoked partitions {}", collection);
            if (KafkaSpout.this.topologyReliabilityMode == Config.TopologyReliabilityMode.ATLEAST_ONCE) {
                collection.forEach(topicPartition -> {
                    KafkaSpout.this.ackRegistry.remove(topicPartition);
                    KafkaSpout.this.failureRegistry.remove(topicPartition);
                });
            } else if (KafkaSpout.this.topologyReliabilityMode == Config.TopologyReliabilityMode.EFFECTIVELY_ONCE) {
                collection.forEach(topicPartition -> KafkaSpout.this.state.remove(topicPartition));
            }
            KafkaSpout.this.assignedPartitions.removeAll(collection);
        }

        public void onPartitionsAssigned(Collection<TopicPartition> collection) {
            LOG.info("assigned partitions {}", collection);
            if (KafkaSpout.this.topologyReliabilityMode == Config.TopologyReliabilityMode.EFFECTIVELY_ONCE) {
                collection.forEach(topicPartition -> {
                    if (KafkaSpout.this.state.containsKey(topicPartition)) {
                        KafkaSpout.this.consumer.seek(topicPartition, ((Long)KafkaSpout.this.state.get(topicPartition)).longValue());
                    }
                });
            }
            KafkaSpout.this.assignedPartitions.addAll(collection);
        }
    }

    static class ConsumerRecordMessageId {
        private TopicPartition topicPartition;
        private long offset;

        ConsumerRecordMessageId(TopicPartition topicPartition, long offset) {
            this.topicPartition = topicPartition;
            this.offset = offset;
        }

        public String toString() {
            return "ConsumerRecordMessageId{topicPartition=" + this.topicPartition + ", offset=" + this.offset + '}';
        }

        TopicPartition getTopicPartition() {
            return this.topicPartition;
        }

        long getOffset() {
            return this.offset;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConsumerRecordMessageId that = (ConsumerRecordMessageId)o;
            if (this.offset != that.offset) {
                return false;
            }
            return this.topicPartition.equals((Object)that.topicPartition);
        }

        public int hashCode() {
            int result = this.topicPartition.hashCode();
            result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
            return result;
        }
    }
}

