/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.heron.common.basics.TypeUtils;

public final class Utils {
    public static final String DEFAULT_STREAM_ID = "default";

    private Utils() {
    }

    public static Object newInstance(String klass) {
        try {
            Class<?> c = Class.forName(klass);
            return c.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Failed to create instance for class: " + klass, e);
        }
    }

    public static List<Object> tuple(Object ... values) {
        return org.apache.heron.api.utils.Utils.tuple(values);
    }

    public static void sleep(long millis) {
        org.apache.heron.api.utils.Utils.sleep(millis);
    }

    public static Map<String, String> readCommandLineOpts() {
        return org.apache.heron.api.utils.Utils.readCommandLineOpts();
    }

    public static byte[] serialize(Object obj) {
        return org.apache.heron.api.utils.Utils.serialize(obj);
    }

    public static Object deserialize(byte[] serialized) {
        return org.apache.heron.api.utils.Utils.deserialize(serialized);
    }

    public static Integer getInt(Object o) {
        return TypeUtils.getInteger(o);
    }

    public static boolean getBoolean(Object o, boolean defaultValue) {
        if (o == null) {
            return defaultValue;
        }
        return TypeUtils.getBoolean(o);
    }

    public static byte[] toByteArray(ByteBuffer buffer) {
        return org.apache.heron.api.utils.Utils.toByteArray(buffer);
    }

    public static <S, T> T get(Map<S, T> m, S key, T defaultValue) {
        return org.apache.heron.api.utils.Utils.get(m, key, defaultValue);
    }
}

