/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.storm.tuple.Tuple;

public final class TupleUtils {
    private TupleUtils() {
    }

    public static boolean isTick(Tuple tuple) {
        return tuple != null && "__system".equals(tuple.getSourceComponent()) && "__tick".equals(tuple.getSourceStreamId());
    }

    public static <T> int listHashCode(List<T> alist) {
        if (alist == null) {
            return 1;
        }
        return Arrays.deepHashCode(alist.toArray());
    }

    public static Map<String, Object> putTickFrequencyIntoComponentConfig(Map<String, Object> conf, int tickFreqSecs) {
        if (conf != null && tickFreqSecs > 0) {
            conf.put("topology.tick.tuple.freq.secs", tickFreqSecs);
        }
        return conf;
    }
}

