/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Time {
    private static final Logger LOG = Logger.getLogger(Time.class.getName());
    private static final AtomicBoolean SIMULATING = new AtomicBoolean(false);
    private static final AtomicLong AUTO_ADVANCE_NANOS_ON_SLEEP = new AtomicLong(0L);
    private static final Map<Thread, AtomicLong> THREAD_SLEEP_TIMES_NANOS = new ConcurrentHashMap<Thread, AtomicLong>();
    private static final Object SLEEP_TIMES_LOCK = new Object();
    private static final AtomicLong SIMULATED_CURR_TIME_NANOS = new AtomicLong(0L);

    private Time() {
    }

    public static boolean isSimulating() {
        return SIMULATING.get();
    }

    public static void sleepUntil(long targetTimeMs) throws InterruptedException {
        if (SIMULATING.get()) {
            Time.simulatedSleepUntilNanos(Time.millisToNanos(targetTimeMs));
        } else {
            long sleepTimeMs = targetTimeMs - Time.currentTimeMillis();
            if (sleepTimeMs > 0L) {
                Thread.sleep(sleepTimeMs);
            }
        }
    }

    public static void sleepUntilNanos(long targetTimeNanos) throws InterruptedException {
        if (SIMULATING.get()) {
            Time.simulatedSleepUntilNanos(targetTimeNanos);
        } else {
            long sleepTimeNanos = targetTimeNanos - Time.nanoTime();
            long sleepTimeMs = Time.nanosToMillis(sleepTimeNanos);
            int sleepTimeNanosSansMs = (int)(sleepTimeNanos % 1000000L);
            if (sleepTimeNanos > 0L) {
                Thread.sleep(sleepTimeMs, sleepTimeNanosSansMs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void simulatedSleepUntilNanos(long targetTimeNanos) throws InterruptedException {
        try {
            Object object = SLEEP_TIMES_LOCK;
            synchronized (object) {
                if (!SIMULATING.get()) {
                    LOG.log(Level.FINER, Thread.currentThread() + " is still sleeping after simulated time disabled.", new RuntimeException("STACK TRACE"));
                    throw new InterruptedException();
                }
                THREAD_SLEEP_TIMES_NANOS.put(Thread.currentThread(), new AtomicLong(targetTimeNanos));
            }
            while (SIMULATED_CURR_TIME_NANOS.get() < targetTimeNanos) {
                object = SLEEP_TIMES_LOCK;
                synchronized (object) {
                    if (!SIMULATING.get()) {
                        LOG.log(Level.FINER, Thread.currentThread() + " is still sleeping after simulated time disabled.", new RuntimeException("STACK TRACE"));
                        throw new InterruptedException();
                    }
                    long autoAdvance = AUTO_ADVANCE_NANOS_ON_SLEEP.get();
                    if (autoAdvance > 0L) {
                        Time.advanceTimeNanos(autoAdvance);
                    }
                }
                Thread.sleep(10L);
            }
        }
        finally {
            THREAD_SLEEP_TIMES_NANOS.remove(Thread.currentThread());
        }
    }

    public static void sleep(long ms) throws InterruptedException {
        if (ms > 0L) {
            if (SIMULATING.get()) {
                Time.simulatedSleepUntilNanos(Time.millisToNanos(Time.currentTimeMillis() + ms));
            } else {
                Thread.sleep(ms);
            }
        }
    }

    public static void parkNanos(long nanos) throws InterruptedException {
        if (nanos > 0L) {
            if (SIMULATING.get()) {
                Time.simulatedSleepUntilNanos(Time.nanoTime() + nanos);
            } else {
                LockSupport.parkNanos(nanos);
            }
        }
    }

    public static void sleepSecs(long secs) throws InterruptedException {
        if (secs > 0L) {
            Time.sleep(secs * 1000L);
        }
    }

    public static long nanoTime() {
        if (SIMULATING.get()) {
            return SIMULATED_CURR_TIME_NANOS.get();
        }
        return System.nanoTime();
    }

    public static long currentTimeMillis() {
        if (SIMULATING.get()) {
            return Time.nanosToMillis(SIMULATED_CURR_TIME_NANOS.get());
        }
        return System.currentTimeMillis();
    }

    public static long nanosToMillis(long nanos) {
        return nanos / 1000000L;
    }

    public static long millisToNanos(long millis) {
        return millis * 1000000L;
    }

    public static long secsToMillis(int secs) {
        return 1000L * (long)secs;
    }

    public static long secsToMillisLong(double secs) {
        return (long)(1000.0 * secs);
    }

    public static int currentTimeSecs() {
        return (int)(Time.currentTimeMillis() / 1000L);
    }

    public static int deltaSecs(int timeInSeconds) {
        return Time.currentTimeSecs() - timeInSeconds;
    }

    public static long deltaMs(long timeInMilliseconds) {
        return Time.currentTimeMillis() - timeInMilliseconds;
    }

    public static void advanceTime(long ms) {
        Time.advanceTimeNanos(Time.millisToNanos(ms));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void advanceTimeNanos(long nanos) {
        if (!SIMULATING.get()) {
            throw new IllegalStateException("Cannot simulate time unless in simulation mode");
        }
        if (nanos < 0L) {
            throw new IllegalArgumentException("advanceTime only accepts positive time as an argument");
        }
        Object object = SLEEP_TIMES_LOCK;
        synchronized (object) {
            long newTime = SIMULATED_CURR_TIME_NANOS.addAndGet(nanos);
            Iterator<AtomicLong> sleepTimesIter = THREAD_SLEEP_TIMES_NANOS.values().iterator();
            while (sleepTimesIter.hasNext()) {
                AtomicLong curr = sleepTimesIter.next();
                if (SIMULATED_CURR_TIME_NANOS.get() < curr.get()) continue;
                sleepTimesIter.remove();
            }
            LOG.log(Level.FINER, "Advanced simulated time to " + newTime);
        }
    }

    public static void advanceTimeSecs(long secs) {
        Time.advanceTime(secs * 1000L);
    }

    public static boolean isThreadWaiting(Thread t) {
        if (!SIMULATING.get()) {
            throw new IllegalStateException("Must be in simulation mode");
        }
        AtomicLong time = THREAD_SLEEP_TIMES_NANOS.get(t);
        return !t.isAlive() || time != null && Time.nanoTime() < time.longValue();
    }

    public static class SimulatedTime
    implements AutoCloseable {
        public SimulatedTime() {
            this(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SimulatedTime(Number advanceTimeMs) {
            Object object = SLEEP_TIMES_LOCK;
            synchronized (object) {
                SIMULATING.set(true);
                SIMULATED_CURR_TIME_NANOS.set(0L);
                THREAD_SLEEP_TIMES_NANOS.clear();
                if (advanceTimeMs != null) {
                    AUTO_ADVANCE_NANOS_ON_SLEEP.set(Time.millisToNanos(advanceTimeMs.longValue()));
                } else {
                    AUTO_ADVANCE_NANOS_ON_SLEEP.set(0L);
                }
                LOG.warning("AutoCloseable Simulated Time Starting...");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = SLEEP_TIMES_LOCK;
            synchronized (object) {
                SIMULATING.set(false);
                LOG.warning("AutoCloseable Simulated Time Ending...");
            }
        }
    }
}

