/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.topology.base;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.heron.api.generated.TopologyAPI;
import org.apache.heron.api.windowing.TimestampExtractor;
import org.apache.heron.api.windowing.WindowingConfigs;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.IWindowedBolt;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.TupleFieldTimestampExtractor;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.TupleImpl;

public abstract class BaseWindowedBolt
implements IWindowedBolt {
    private static final long serialVersionUID = -3998164228343123590L;
    protected final transient WindowingConfigs windowConfiguration = new WindowingConfigs();
    protected TimestampExtractor timestampExtractor;

    protected BaseWindowedBolt() {
    }

    private BaseWindowedBolt withWindowLength(Count count) {
        if (count.value <= 0) {
            throw new IllegalArgumentException("Window length must be positive [" + count + "]");
        }
        this.windowConfiguration.setTopologyBoltsWindowLengthCount(count.value);
        return this;
    }

    private BaseWindowedBolt withWindowLength(Duration duration) {
        if (duration.value <= 0) {
            throw new IllegalArgumentException("Window length must be positive [" + duration + "]");
        }
        this.windowConfiguration.setTopologyBoltsWindowLengthDurationMs(duration.value);
        return this;
    }

    private BaseWindowedBolt withSlidingInterval(Count count) {
        if (count.value <= 0) {
            throw new IllegalArgumentException("Sliding interval must be positive [" + count + "]");
        }
        this.windowConfiguration.setTopologyBoltsSlidingIntervalCount(count.value);
        return this;
    }

    private BaseWindowedBolt withSlidingInterval(Duration duration) {
        if (duration.value <= 0) {
            throw new IllegalArgumentException("Sliding interval must be positive [" + duration + "]");
        }
        this.windowConfiguration.setTopologyBoltsSlidingIntervalDurationMs(duration.value);
        return this;
    }

    public BaseWindowedBolt withWindow(Count windowLength, Count slidingInterval) {
        return this.withWindowLength(windowLength).withSlidingInterval(slidingInterval);
    }

    public BaseWindowedBolt withWindow(Count windowLength, Duration slidingInterval) {
        return this.withWindowLength(windowLength).withSlidingInterval(slidingInterval);
    }

    public BaseWindowedBolt withWindow(Duration windowLength, Count slidingInterval) {
        return this.withWindowLength(windowLength).withSlidingInterval(slidingInterval);
    }

    public BaseWindowedBolt withWindow(Duration windowLength, Duration slidingInterval) {
        return this.withWindowLength(windowLength).withSlidingInterval(slidingInterval);
    }

    public BaseWindowedBolt withWindow(Count windowLength) {
        return this.withWindowLength(windowLength).withSlidingInterval(new Count(1));
    }

    public BaseWindowedBolt withWindow(Duration windowLength) {
        return this.withWindowLength(windowLength).withSlidingInterval(new Count(1));
    }

    public BaseWindowedBolt withTumblingWindow(Count count) {
        return this.withWindowLength(count).withSlidingInterval(count);
    }

    public BaseWindowedBolt withTumblingWindow(Duration duration) {
        return this.withWindowLength(duration).withSlidingInterval(duration);
    }

    public BaseWindowedBolt withTimestampField(String fieldName) {
        return this.withTimestampExtractor(TupleFieldTimestampExtractor.of(fieldName));
    }

    public BaseWindowedBolt withTimestampExtractor(final org.apache.storm.windowing.TimestampExtractor timestampExtractor) {
        if (this.timestampExtractor != null) {
            throw new IllegalArgumentException("Window is already configured with a timestamp extractor: " + timestampExtractor);
        }
        this.timestampExtractor = new TimestampExtractor(){

            @Override
            public long extractTimestamp(org.apache.heron.api.tuple.Tuple tuple) {
                return timestampExtractor.extractTimestamp(new TupleImpl(tuple));
            }
        };
        return this;
    }

    @Override
    public org.apache.storm.windowing.TimestampExtractor getTimestampExtractor() {
        return this.timestampExtractor == null ? null : new org.apache.storm.windowing.TimestampExtractor(){

            @Override
            public long extractTimestamp(final Tuple tuple) {
                return BaseWindowedBolt.this.timestampExtractor.extractTimestamp(new org.apache.heron.api.tuple.Tuple(){

                    @Override
                    public int size() {
                        return tuple.size();
                    }

                    @Override
                    public int fieldIndex(String field) {
                        return tuple.fieldIndex(field);
                    }

                    @Override
                    public boolean contains(String field) {
                        return tuple.contains(field);
                    }

                    @Override
                    public Object getValue(int i) {
                        return tuple.getValue(i);
                    }

                    @Override
                    public String getString(int i) {
                        return tuple.getString(i);
                    }

                    @Override
                    public Integer getInteger(int i) {
                        return tuple.getInteger(i);
                    }

                    @Override
                    public Long getLong(int i) {
                        return tuple.getLong(i);
                    }

                    @Override
                    public Boolean getBoolean(int i) {
                        return tuple.getBoolean(i);
                    }

                    @Override
                    public Short getShort(int i) {
                        return tuple.getShort(i);
                    }

                    @Override
                    public Byte getByte(int i) {
                        return tuple.getByte(i);
                    }

                    @Override
                    public Double getDouble(int i) {
                        return tuple.getDouble(i);
                    }

                    @Override
                    public Float getFloat(int i) {
                        return tuple.getFloat(i);
                    }

                    @Override
                    public byte[] getBinary(int i) {
                        return tuple.getBinary(i);
                    }

                    @Override
                    public Object getValueByField(String field) {
                        return tuple.getValueByField(field);
                    }

                    @Override
                    public String getStringByField(String field) {
                        return tuple.getStringByField(field);
                    }

                    @Override
                    public Integer getIntegerByField(String field) {
                        return tuple.getIntegerByField(field);
                    }

                    @Override
                    public Long getLongByField(String field) {
                        return tuple.getLongByField(field);
                    }

                    @Override
                    public Boolean getBooleanByField(String field) {
                        return tuple.getBooleanByField(field);
                    }

                    @Override
                    public Short getShortByField(String field) {
                        return tuple.getShortByField(field);
                    }

                    @Override
                    public Byte getByteByField(String field) {
                        return tuple.getByteByField(field);
                    }

                    @Override
                    public Double getDoubleByField(String field) {
                        return tuple.getDoubleByField(field);
                    }

                    @Override
                    public Float getFloatByField(String field) {
                        return tuple.getFloatByField(field);
                    }

                    @Override
                    public byte[] getBinaryByField(String field) {
                        return tuple.getBinaryByField(field);
                    }

                    @Override
                    public List<Object> getValues() {
                        return tuple.getValues();
                    }

                    @Override
                    public org.apache.heron.api.tuple.Fields getFields() {
                        return new org.apache.heron.api.tuple.Fields(tuple.getFields().toList());
                    }

                    @Override
                    public List<Object> select(org.apache.heron.api.tuple.Fields selector) {
                        return tuple.select(new Fields(selector.toString()));
                    }

                    @Override
                    public TopologyAPI.StreamId getSourceGlobalStreamId() {
                        return TopologyAPI.StreamId.newBuilder().setId(tuple.getSourceStreamId()).setComponentName(tuple.getSourceComponent()).build();
                    }

                    @Override
                    public String getSourceComponent() {
                        return tuple.getSourceComponent();
                    }

                    @Override
                    public int getSourceTask() {
                        return tuple.getSourceTask();
                    }

                    @Override
                    public String getSourceStreamId() {
                        return tuple.getSourceStreamId();
                    }

                    @Override
                    public void resetValues() {
                        tuple.resetValues();
                    }
                });
            }
        };
    }

    public BaseWindowedBolt withLateTupleStream(String streamId) {
        this.windowConfiguration.setTopologyBoltsLateTupleStream(streamId);
        return this;
    }

    public BaseWindowedBolt withLag(Duration duration) {
        this.windowConfiguration.setTopologyBoltsTupleTimestampMaxLagMs(duration.value);
        return this;
    }

    public BaseWindowedBolt withWatermarkInterval(Duration interval) {
        this.windowConfiguration.setTopologyBoltsWatermarkEventIntervalMs(interval.value);
        return this;
    }

    @Override
    public void prepare(Map topoConf, TopologyContext context, OutputCollector collector) {
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return this.windowConfiguration;
    }

    public static class Duration
    implements Serializable {
        private static final long serialVersionUID = 5654070568075477148L;
        public final int value;

        public Duration(int value, TimeUnit timeUnit) {
            this.value = (int)timeUnit.toMillis(value);
        }

        public static Duration of(int milliseconds) {
            return new Duration(milliseconds, TimeUnit.MILLISECONDS);
        }

        public static Duration days(int days) {
            return new Duration(days, TimeUnit.DAYS);
        }

        public static Duration hours(int hours) {
            return new Duration(hours, TimeUnit.HOURS);
        }

        public static Duration minutes(int minutes) {
            return new Duration(minutes, TimeUnit.MINUTES);
        }

        public static Duration seconds(int seconds) {
            return new Duration(seconds, TimeUnit.SECONDS);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Duration duration = (Duration)o;
            return this.value == duration.value;
        }

        public int hashCode() {
            return this.value;
        }

        public String toString() {
            return "Duration{value=" + this.value + '}';
        }
    }

    public static class Count
    implements Serializable {
        private static final long serialVersionUID = -2290882388716246812L;
        public final int value;

        public Count(int value) {
            this.value = value;
        }

        public static Count of(int value) {
            return new Count(value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Count count = (Count)o;
            return this.value == count.value;
        }

        public int hashCode() {
            return this.value;
        }

        public String toString() {
            return "Count{value=" + this.value + '}';
        }
    }
}

