/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.topology;

import java.util.Map;
import java.util.logging.Logger;
import org.apache.heron.api.bolt.OutputCollector;
import org.apache.heron.api.topology.IUpdatable;
import org.apache.heron.api.topology.OutputFieldsDeclarer;
import org.apache.heron.api.topology.TopologyContext;
import org.apache.heron.api.tuple.Tuple;
import org.apache.storm.task.OutputCollectorImpl;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.OutputFieldsGetter;
import org.apache.storm.tuple.TupleImpl;
import org.apache.storm.utils.ConfigUtils;

public class IRichBoltDelegate
implements org.apache.heron.api.bolt.IRichBolt,
IUpdatable {
    private static final Logger LOG = Logger.getLogger(IRichBoltDelegate.class.getName());
    private static final long serialVersionUID = 8350418148268852902L;
    private IRichBolt delegate;
    private org.apache.storm.task.TopologyContext topologyContextImpl;
    private OutputCollectorImpl outputCollectorImpl;

    public IRichBoltDelegate(IRichBolt delegate) {
        this.delegate = delegate;
    }

    @Override
    public void prepare(Map<String, Object> conf, TopologyContext context, OutputCollector collector) {
        this.topologyContextImpl = new org.apache.storm.task.TopologyContext(context);
        this.outputCollectorImpl = new OutputCollectorImpl(collector);
        this.delegate.prepare(conf, this.topologyContextImpl, this.outputCollectorImpl);
    }

    @Override
    public void cleanup() {
        this.delegate.cleanup();
    }

    @Override
    public void execute(Tuple tuple) {
        TupleImpl impl = new TupleImpl(tuple);
        this.delegate.execute(impl);
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        OutputFieldsGetter getter = new OutputFieldsGetter(declarer);
        this.delegate.declareOutputFields(getter);
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        Map<String, Object> config = this.delegate.getComponentConfiguration();
        return ConfigUtils.translateComponentConfig(config);
    }

    @Override
    public void update(TopologyContext topologyContext) {
        if (this.delegate instanceof IUpdatable) {
            ((IUpdatable)((Object)this.delegate)).update(topologyContext);
        } else {
            LOG.warning(String.format("Update() event received but can not call update() on delegate because it does not implement %s: %s", IUpdatable.class.getName(), this.delegate));
        }
    }
}

