/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.task;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.storm.clojure.lang.Atom;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.hooks.ITaskHook;
import org.apache.storm.hooks.ITaskHookDelegate;
import org.apache.storm.metric.api.CombinedMetric;
import org.apache.storm.metric.api.ICombiner;
import org.apache.storm.metric.api.IMetric;
import org.apache.storm.metric.api.IReducer;
import org.apache.storm.metric.api.MetricDelegate;
import org.apache.storm.metric.api.ReducedMetric;
import org.apache.storm.task.IMetricsContext;
import org.apache.storm.task.WorkerTopologyContext;
import org.apache.storm.tuple.Fields;

public class TopologyContext
extends WorkerTopologyContext
implements IMetricsContext {
    private org.apache.heron.api.topology.TopologyContext delegate;

    public TopologyContext(StormTopology topology, Map stormConf, Map<Integer, String> taskToComponent, Map<String, List<Integer>> componentToSortedTasks, Map<String, Map<String, Fields>> componentToStreamToFields, String stormId, String codeDir, String pidDir, Integer taskId, Integer workerPort, List<Integer> workerTasks, Map<String, Object> defaultResources, Map<String, Object> userResources, Map<String, Object> executorData, Map<String, Object> registeredMetrics, Atom openOrPrepareWasCalled) {
        super((org.apache.heron.api.topology.TopologyContext)null);
    }

    public TopologyContext(org.apache.heron.api.topology.TopologyContext delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    public int getThisTaskId() {
        return this.delegate.getThisTaskId();
    }

    public String getThisComponentId() {
        return this.delegate.getThisComponentId();
    }

    public Fields getThisOutputFields(String streamId) {
        return new Fields(this.delegate.getThisOutputFields(streamId));
    }

    public Set<String> getThisStreams() {
        return this.delegate.getThisStreams();
    }

    public int getThisTaskIndex() {
        return this.delegate.getThisTaskIndex();
    }

    public void setTaskData(String name, Object data) {
        this.delegate.setTaskData(name, data);
    }

    public Object getTaskData(String name) {
        return this.delegate.getTaskData(name);
    }

    public void addTaskHook(ITaskHook newHook) {
        Collection<org.apache.heron.api.hooks.ITaskHook> hooks = this.delegate.getHooks();
        if (hooks != null) {
            for (org.apache.heron.api.hooks.ITaskHook hook : hooks) {
                if (!(hook instanceof ITaskHookDelegate)) continue;
                ITaskHookDelegate delegateHook = (ITaskHookDelegate)hook;
                delegateHook.addHook(newHook);
                return;
            }
            throw new RuntimeException("StormCompat taskHooks not setup properly");
        }
        ITaskHookDelegate delegateHook = new ITaskHookDelegate();
        delegateHook.addHook(newHook);
        this.delegate.addTaskHook(delegateHook);
    }

    public Collection<ITaskHook> getHooks() {
        Collection<org.apache.heron.api.hooks.ITaskHook> hooks = this.delegate.getHooks();
        if (hooks != null) {
            for (org.apache.heron.api.hooks.ITaskHook hook : hooks) {
                if (!(hook instanceof ITaskHookDelegate)) continue;
                return ((ITaskHookDelegate)hook).getHooks();
            }
        }
        return null;
    }

    @Override
    public <T extends IMetric> T registerMetric(String name, T metric, int timeBucketSizeInSecs) {
        MetricDelegate d = new MetricDelegate(metric);
        this.delegate.registerMetric(name, d, timeBucketSizeInSecs);
        return metric;
    }

    @Override
    public ReducedMetric registerMetric(String name, IReducer reducer, int timeBucketSizeInSecs) {
        return this.registerMetric(name, new ReducedMetric(reducer), timeBucketSizeInSecs);
    }

    @Override
    public CombinedMetric registerMetric(String name, ICombiner combiner, int timeBucketSizeInSecs) {
        return this.registerMetric(name, new CombinedMetric(combiner), timeBucketSizeInSecs);
    }
}

