/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serializers.DefaultSerializers;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.apache.storm.serialization.IKryoDecorator;
import org.apache.storm.serialization.IKryoFactory;
import org.apache.storm.tuple.Values;
import org.apache.storm.utils.ListDelegate;
import org.apache.storm.utils.Utils;

public final class SerializationFactory {
    public static final Logger LOG = Logger.getLogger(SerializationFactory.class.getName());

    private SerializationFactory() {
    }

    public static Kryo getKryo(Map conf) {
        IKryoFactory kryoFactory = (IKryoFactory)Utils.newInstance((String)conf.get("topology.kryo.factory"));
        Kryo k = kryoFactory.getKryo(conf);
        k.register(byte[].class);
        k.register(ListDelegate.class);
        k.register(ArrayList.class);
        k.register(HashMap.class);
        k.register(HashSet.class);
        k.register(BigInteger.class, (Serializer)new DefaultSerializers.BigIntegerSerializer());
        k.register(Values.class);
        Map<String, String> registrations = SerializationFactory.normalizeKryoRegister(conf);
        kryoFactory.preRegister(k, conf);
        boolean skipMissing = (Boolean)conf.get("topology.skip.missing.kryo.registrations");
        for (String klassName : registrations.keySet()) {
            String serializerClassName = registrations.get(klassName);
            try {
                Class<?> klass = Class.forName(klassName);
                Class<?> serializerClass = null;
                if (serializerClassName != null) {
                    serializerClass = Class.forName(serializerClassName);
                }
                LOG.info("Doing kryo.register for class " + klass);
                if (serializerClass == null) {
                    k.register(klass);
                    continue;
                }
                k.register(klass, SerializationFactory.resolveSerializerInstance(k, klass, serializerClass));
            }
            catch (ClassNotFoundException e) {
                if (skipMissing) {
                    LOG.info("Could not find serialization or class for " + serializerClassName + ". Skipping registration...");
                    continue;
                }
                throw new RuntimeException(e);
            }
        }
        kryoFactory.postRegister(k, conf);
        if (conf.get("topology.kryo.decorators") != null) {
            for (String klassName : (List)conf.get("topology.kryo.decorators")) {
                try {
                    Class<?> klass = Class.forName(klassName);
                    IKryoDecorator decorator = (IKryoDecorator)klass.newInstance();
                    decorator.decorate(k);
                }
                catch (ClassNotFoundException e) {
                    if (skipMissing) {
                        LOG.info("Could not find kryo decorator named " + klassName + ". Skipping registration...");
                        continue;
                    }
                    throw new RuntimeException(e);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        kryoFactory.postDecorate(k, conf);
        return k;
    }

    private static Serializer resolveSerializerInstance(Kryo k, Class superClass, Class<? extends Serializer> serializerClass) {
        try {
            Constructor<? extends Serializer> ctor = serializerClass.getConstructor(Kryo.class, Class.class);
            return ctor.newInstance(k, superClass);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            try {
                Constructor<? extends Serializer> ctor = serializerClass.getConstructor(Kryo.class);
                return ctor.newInstance(k);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException2) {
                try {
                    Constructor<? extends Serializer> ctor = serializerClass.getConstructor(Class.class);
                    return ctor.newInstance(k);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException3) {
                    try {
                        return serializerClass.newInstance();
                    }
                    catch (IllegalAccessException | InstantiationException reflectiveOperationException4) {
                        throw new IllegalArgumentException(String.format("Unable to create serializer \"%s\" for class: %s", serializerClass.getName(), superClass.getName()));
                    }
                }
            }
        }
    }

    private static Map<String, String> normalizeKryoRegister(Map conf) {
        Object res = conf.get("topology.kryo.register");
        if (res == null) {
            return new TreeMap<String, String>();
        }
        Map ret = new HashMap();
        if (res instanceof Map) {
            ret = (Map)res;
        } else {
            for (Object o : (List)res) {
                if (o instanceof Map) {
                    ret.putAll((Map)o);
                    continue;
                }
                ret.put((String)o, null);
            }
        }
        return new TreeMap<String, String>(ret);
    }
}

