/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SerializableSerializer
extends Serializer<Object> {
    public void write(Kryo kryo, Output output, Object object) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(object);
            oos.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] ser = bos.toByteArray();
        output.writeInt(ser.length);
        output.writeBytes(ser);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Object read(Kryo kryo, Input input, Class c) {
        int len = input.readInt();
        byte[] ser = new byte[len];
        input.readBytes(ser);
        try (ByteArrayInputStream bis = new ByteArrayInputStream(ser);){
            Object object;
            try (ObjectInputStream ois = new ObjectInputStream(bis);){
                object = ois.readObject();
            }
            return object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

