/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hooks;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.heron.api.topology.TopologyContext;
import org.apache.heron.common.basics.TypeUtils;
import org.apache.storm.hooks.ITaskHook;
import org.apache.storm.hooks.info.BoltAckInfo;
import org.apache.storm.hooks.info.BoltExecuteInfo;
import org.apache.storm.hooks.info.BoltFailInfo;
import org.apache.storm.hooks.info.EmitInfo;
import org.apache.storm.hooks.info.SpoutAckInfo;
import org.apache.storm.hooks.info.SpoutFailInfo;

public class ITaskHookDelegate
implements org.apache.heron.api.hooks.ITaskHook {
    private List<ITaskHook> hooks = new LinkedList<ITaskHook>();
    private Map conf;

    public void addHook(ITaskHook hook) {
        this.hooks.add(hook);
    }

    public List<ITaskHook> getHooks() {
        return this.hooks;
    }

    public Map getConf() {
        return this.conf;
    }

    @Override
    public void prepare(Map<String, Object> newConf, TopologyContext context) {
        this.conf = newConf;
        if (!newConf.containsKey("stormcompat.topology.auto.task.hooks")) {
            throw new RuntimeException("StormCompat Translation not done for task hooks");
        }
        List<String> hookClassNames = TypeUtils.getListOfStrings(newConf.get("stormcompat.topology.auto.task.hooks"));
        for (String className : hookClassNames) {
            ITaskHook hook;
            try {
                hook = (ITaskHook)Class.forName(className).newInstance();
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex + " ITaskHook class must be in class path.");
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex + " ITaskHook class must be concrete.");
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex + " ITaskHook class must have a no-arg constructor.");
            }
            this.hooks.add(hook);
        }
        org.apache.storm.task.TopologyContext ctxt = new org.apache.storm.task.TopologyContext(context);
        for (ITaskHook hook : this.hooks) {
            hook.prepare(newConf, ctxt);
        }
    }

    @Override
    public void cleanup() {
        for (ITaskHook hook : this.hooks) {
            hook.cleanup();
        }
    }

    @Override
    public void emit(org.apache.heron.api.hooks.info.EmitInfo info) {
        EmitInfo emit = new EmitInfo(info);
        for (ITaskHook hook : this.hooks) {
            hook.emit(emit);
        }
    }

    @Override
    public void spoutAck(org.apache.heron.api.hooks.info.SpoutAckInfo info) {
        SpoutAckInfo ack = new SpoutAckInfo(info);
        for (ITaskHook hook : this.hooks) {
            hook.spoutAck(ack);
        }
    }

    @Override
    public void spoutFail(org.apache.heron.api.hooks.info.SpoutFailInfo info) {
        SpoutFailInfo fail = new SpoutFailInfo(info);
        for (ITaskHook hook : this.hooks) {
            hook.spoutFail(fail);
        }
    }

    @Override
    public void boltAck(org.apache.heron.api.hooks.info.BoltAckInfo info) {
        BoltAckInfo ack = new BoltAckInfo(info);
        for (ITaskHook hook : this.hooks) {
            hook.boltAck(ack);
        }
    }

    @Override
    public void boltFail(org.apache.heron.api.hooks.info.BoltFailInfo info) {
        BoltFailInfo fail = new BoltFailInfo(info);
        for (ITaskHook hook : this.hooks) {
            hook.boltFail(fail);
        }
    }

    @Override
    public void boltExecute(org.apache.heron.api.hooks.info.BoltExecuteInfo info) {
        BoltExecuteInfo execute = new BoltExecuteInfo(info);
        for (ITaskHook hook : this.hooks) {
            hook.boltExecute(execute);
        }
    }
}

