/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm;

import com.esotericsoftware.kryo.Serializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.serialization.IKryoDecorator;
import org.apache.storm.serialization.IKryoFactory;

public class Config
extends HashMap<String, Object> {
    private static final long serialVersionUID = 4781760255471579334L;
    public static final String TOPOLOGY_ENABLE_MESSAGE_TIMEOUTS = "topology.enable.message.timeouts";
    public static final String TOPOLOGY_OPTIMIZE = "topology.optimize";
    public static final String TOPOLOGY_TASKS = "topology.tasks";
    public static final String TOPOLOGY_KRYO_REGISTER = "topology.kryo.register";
    public static final String TOPOLOGY_KRYO_DECORATORS = "topology.kryo.decorators";
    public static final String TOPOLOGY_KRYO_FACTORY = "topology.kryo.factory";
    public static final String TOPOLOGY_SKIP_MISSING_KRYO_REGISTRATIONS = "topology.skip.missing.kryo.registrations";
    public static final String TOPOLOGY_STATE_SYNCHRONIZATION_TIMEOUT_SECS = "topology.state.synchronization.timeout.secs";
    public static final String TOPOLOGY_FALL_BACK_ON_JAVA_SERIALIZATION = "topology.fall.back.on.java.serialization";
    public static final String TOPOLOGY_WORKER_CHILDOPTS = "topology.worker.childopts";
    public static final String TOPOLOGY_TRANSACTIONAL_ID = "topology.transactional.id";
    public static final String TOPOLOGY_TICK_TUPLE_FREQ_SECS = "topology.tick.tuple.freq.secs";
    public static final String TOPOLOGY_ERROR_THROTTLE_INTERVAL_SECS = "topology.error.throttle.interval.secs";
    public static final String TOPOLOGY_MAX_ERROR_REPORT_PER_INTERVAL = "topology.max.error.report.per.interval";
    public static final String TOPOLOGY_DEBUG = "topology.debug";
    public static final String TOPOLOGY_WORKERS = "topology.workers";
    public static final String TOPOLOGY_ACKER_EXECUTORS = "topology.acker.executors";
    public static final String TOPOLOGY_MESSAGE_TIMEOUT_SECS = "topology.message.timeout.secs";
    public static final String TOPOLOGY_METRICS_CONSUMER_REGISTER = "topology.metrics.consumer.register";
    public static final String TOPOLOGY_MAX_TASK_PARALLELISM = "topology.max.task.parallelism";
    public static final String TOPOLOGY_MAX_SPOUT_PENDING = "topology.max.spout.pending";
    public static final String TOPOLOGY_SPOUT_WAIT_STRATEGY = "topology.spout.wait.strategy";
    public static final String TOPOLOGY_SLEEP_SPOUT_WAIT_STRATEGY_TIME_MS = "topology.sleep.spout.wait.strategy.time.ms";
    public static final String TOPOLOGY_STATS_SAMPLE_RATE = "topology.stats.sample.rate";
    public static final String TOPOLOGY_AUTO_TASK_HOOKS = "topology.auto.task.hooks";
    public static final String TOPOLOGY_NAME = "topology.name";
    public static final String TOPOLOGY_TEAM_NAME = "topology.team.name";
    public static final String TOPOLOGY_TEAM_EMAIL = "topology.team.email";
    public static final String TOPOLOGY_CAP_TICKET = "topology.cap.ticket";
    public static final String TOPOLOGY_PROJECT_NAME = "topology.project.name";
    public static final String STORM_ZOOKEEPER_SERVERS = "storm.zookeeper.servers";
    public static final String STORM_ZOOKEEPER_PORT = "storm.zookeeper.port";
    public static final String TRANSACTIONAL_ZOOKEEPER_ROOT = "transactional.zookeeper.root";
    public static final String STORM_ZOOKEEPER_SESSION_TIMEOUT = "storm.zookeeper.session.timeout";
    public static final String STORM_ZOOKEEPER_CONNECTION_TIMEOUT = "storm.zookeeper.connection.timeout";
    public static final String STORM_ZOOKEEPER_RETRY_TIMES = "storm.zookeeper.retry.times";
    public static final String STORM_ZOOKEEPER_RETRY_INTERVAL = "storm.zookeeper.retry.interval";
    public static final String TRANSACTIONAL_ZOOKEEPER_SERVERS = "transactional.zookeeper.servers";
    public static final String TRANSACTIONAL_ZOOKEEPER_PORT = "transactional.zookeeper.port";
    public static final String TOPOLOGY_BOLTS_WINDOW_LENGTH_COUNT = "topology.bolts.window.length.count";
    public static final String TOPOLOGY_BOLTS_WINDOW_LENGTH_DURATION_MS = "topology.bolts.window.length.duration.ms";
    public static final String TOPOLOGY_BOLTS_SLIDING_INTERVAL_COUNT = "topology.bolts.window.sliding.interval.count";
    public static final String TOPOLOGY_BOLTS_SLIDING_INTERVAL_DURATION_MS = "topology.bolts.window.sliding.interval.duration.ms";
    public static final String TOPOLOGY_BOLTS_LATE_TUPLE_STREAM = "topology.bolts.late.tuple.stream";
    public static final String TOPOLOGY_BOLTS_TUPLE_TIMESTAMP_MAX_LAG_MS = "topology.bolts.tuple.timestamp.max.lag.ms";
    public static final String TOPOLOGY_BOLTS_WATERMARK_EVENT_INTERVAL_MS = "topology.bolts.watermark.event.interval.ms";
    public static final String TOPOLOGY_ENVIRONMENT = "topology.environment";
    public static final String STORMCOMPAT_TOPOLOGY_AUTO_TASK_HOOKS = "stormcompat.topology.auto.task.hooks";

    public static void setDebug(Map conf, boolean isOn) {
        conf.put(TOPOLOGY_DEBUG, isOn);
    }

    public static void setTeamName(Map conf, String teamName) {
        conf.put(TOPOLOGY_TEAM_NAME, teamName);
    }

    public static void setTeamEmail(Map conf, String teamEmail) {
        conf.put(TOPOLOGY_TEAM_EMAIL, teamEmail);
    }

    public static void setTopologyCapTicket(Map conf, String ticket) {
        conf.put(TOPOLOGY_CAP_TICKET, ticket);
    }

    public static void setTopologyProjectName(Map conf, String project) {
        conf.put(TOPOLOGY_PROJECT_NAME, project);
    }

    public static void setNumWorkers(Map conf, int workers) {
        conf.put(TOPOLOGY_WORKERS, workers);
    }

    public static void setNumAckers(Map conf, int numExecutors) {
        conf.put(TOPOLOGY_ACKER_EXECUTORS, numExecutors);
    }

    public static void setMessageTimeoutSecs(Map conf, int secs) {
        conf.put(TOPOLOGY_MESSAGE_TIMEOUT_SECS, secs);
    }

    public static void registerSerialization(Map conf, Class klass) {
        Config.getRegisteredSerializations(conf).add(klass.getName());
    }

    public static void registerSerialization(Map conf, Class klass, Class<? extends Serializer> serializerClass) {
        HashMap<String, String> register = new HashMap<String, String>();
        register.put(klass.getName(), serializerClass.getName());
        Config.getRegisteredSerializations(conf).add(register);
    }

    public static void registerDecorator(Map conf, Class<? extends IKryoDecorator> klass) {
        Config.getRegisteredDecorators(conf).add(klass.getName());
    }

    public static void setKryoFactory(Map conf, Class<? extends IKryoFactory> klass) {
        conf.put(TOPOLOGY_KRYO_FACTORY, klass.getName());
    }

    public static void setSkipMissingKryoRegistrations(Map conf, boolean skip) {
        conf.put(TOPOLOGY_SKIP_MISSING_KRYO_REGISTRATIONS, skip);
    }

    public static void setMaxTaskParallelism(Map conf, int max) {
        conf.put(TOPOLOGY_MAX_TASK_PARALLELISM, max);
    }

    public static void setMaxSpoutPending(Map conf, int max) {
        conf.put(TOPOLOGY_MAX_SPOUT_PENDING, max);
    }

    public static void setStatsSampleRate(Map conf, double rate) {
        conf.put(TOPOLOGY_STATS_SAMPLE_RATE, rate);
    }

    public static void setFallBackOnJavaSerialization(Map conf, boolean fallback) {
        conf.put(TOPOLOGY_FALL_BACK_ON_JAVA_SERIALIZATION, fallback);
    }

    private static List getRegisteredSerializations(Map conf) {
        ArrayList ret = !conf.containsKey(TOPOLOGY_KRYO_REGISTER) ? new ArrayList() : new ArrayList((List)conf.get(TOPOLOGY_KRYO_REGISTER));
        conf.put(TOPOLOGY_KRYO_REGISTER, ret);
        return ret;
    }

    private static List<String> getRegisteredDecorators(Map conf) {
        ArrayList<String> ret = !conf.containsKey(TOPOLOGY_KRYO_DECORATORS) ? new ArrayList<String>() : new ArrayList((List)conf.get(TOPOLOGY_KRYO_DECORATORS));
        conf.put(TOPOLOGY_KRYO_DECORATORS, ret);
        return ret;
    }

    public static void setEnvironment(Map<String, Object> conf, Map env) {
        conf.put(TOPOLOGY_ENVIRONMENT, env);
    }

    public void setDebug(boolean isOn) {
        Config.setDebug(this, isOn);
    }

    public void setTeamName(String teamName) {
        Config.setTeamName(this, teamName);
    }

    public void setTeamEmail(String teamEmail) {
        Config.setTeamEmail(this, teamEmail);
    }

    public void setTopologyCapTicket(String ticket) {
        Config.setTopologyCapTicket(this, ticket);
    }

    public void setTopologyProjectName(String project) {
        Config.setTopologyProjectName(this, project);
    }

    @Deprecated
    public void setOptimize(boolean isOn) {
        this.put(TOPOLOGY_OPTIMIZE, isOn);
    }

    public void setNumWorkers(int workers) {
        Config.setNumWorkers(this, workers);
    }

    public void setNumAckers(int numExecutors) {
        Config.setNumAckers(this, numExecutors);
    }

    public void setMessageTimeoutSecs(int secs) {
        Config.setMessageTimeoutSecs(this, secs);
    }

    public void registerSerialization(Class klass) {
        Config.registerSerialization(this, klass);
    }

    public void registerSerialization(Class klass, Class<? extends Serializer> serializerClass) {
        Config.registerSerialization(this, klass, serializerClass);
    }

    public void registerMetricsConsumer(Class klass, Object argument, long parallelismHint) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("class", klass.getCanonicalName());
        m.put("parallelism.hint", parallelismHint);
        m.put("argument", argument);
        ArrayList l = (ArrayList)this.get(TOPOLOGY_METRICS_CONSUMER_REGISTER);
        if (l == null) {
            l = new ArrayList();
        }
        l.add(m);
        this.put(TOPOLOGY_METRICS_CONSUMER_REGISTER, l);
    }

    public void registerMetricsConsumer(Class klass, long parallelismHint) {
        this.registerMetricsConsumer(klass, null, parallelismHint);
    }

    public void registerMetricsConsumer(Class klass) {
        this.registerMetricsConsumer(klass, null, 1L);
    }

    public void registerDecorator(Class<? extends IKryoDecorator> klass) {
        Config.registerDecorator(this, klass);
    }

    public void setKryoFactory(Class<? extends IKryoFactory> klass) {
        Config.setKryoFactory(this, klass);
    }

    public void setSkipMissingKryoRegistrations(boolean skip) {
        Config.setSkipMissingKryoRegistrations(this, skip);
    }

    public void setMaxTaskParallelism(int max) {
        Config.setMaxTaskParallelism(this, max);
    }

    public void setMaxSpoutPending(int max) {
        Config.setMaxSpoutPending(this, max);
    }

    public void setStatsSampleRate(double rate) {
        Config.setStatsSampleRate(this, rate);
    }

    public void setFallBackOnJavaSerialization(boolean fallback) {
        Config.setFallBackOnJavaSerialization(this, fallback);
    }
}

