/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.instance.spout;

import java.time.Duration;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.heron.api.serializer.IPluggableSerializer;
import org.apache.heron.api.spout.ISpoutOutputCollector;
import org.apache.heron.common.basics.Communicator;
import org.apache.heron.common.utils.metrics.ComponentMetrics;
import org.apache.heron.common.utils.misc.PhysicalPlanHelper;
import org.apache.heron.common.utils.misc.TupleKeyGenerator;
import org.apache.heron.instance.AbstractOutputCollector;
import org.apache.heron.instance.spout.RootTupleInfo;
import org.apache.heron.proto.system.HeronTuples;
import org.apache.heron.shaded.com.google.protobuf.Message;

public class SpoutOutputCollectorImpl
extends AbstractOutputCollector
implements ISpoutOutputCollector {
    private static final Logger LOG = Logger.getLogger(SpoutOutputCollectorImpl.class.getName());
    private final LinkedHashMap<Long, RootTupleInfo> inFlightTuples;
    private final TupleKeyGenerator keyGenerator;
    private final Queue<RootTupleInfo> immediateAcks;

    protected SpoutOutputCollectorImpl(IPluggableSerializer serializer, PhysicalPlanHelper helper, Communicator<Message> streamOutQueue, ComponentMetrics spoutMetrics) {
        super(serializer, helper, streamOutQueue, spoutMetrics);
        if (helper.getMySpout() == null) {
            throw new RuntimeException(helper.getMyTaskId() + " is not a spout ");
        }
        this.keyGenerator = new TupleKeyGenerator();
        this.inFlightTuples = new LinkedHashMap();
        this.immediateAcks = !this.ackEnabled ? new ArrayDeque<RootTupleInfo>() : null;
    }

    @Override
    public List<Integer> emit(String streamId, List<Object> tuple, Object messageId) {
        return this.admitSpoutTuple(streamId, tuple, messageId, null);
    }

    @Override
    public void emitDirect(int taskId, String streamId, List<Object> tuple, Object messageId) {
        this.admitSpoutTuple(streamId, tuple, messageId, taskId);
    }

    @Override
    public void reportError(Throwable error) {
        LOG.log(Level.SEVERE, "Reporting an error in topology code ", error);
    }

    public boolean isAckEnabled() {
        return this.ackEnabled;
    }

    public int numInFlight() {
        return this.inFlightTuples.size();
    }

    Queue<RootTupleInfo> getImmediateAcks() {
        return this.immediateAcks;
    }

    RootTupleInfo retireInFlight(long rootId) {
        return (RootTupleInfo)this.inFlightTuples.remove(rootId);
    }

    List<RootTupleInfo> retireExpired(Duration timeout) {
        RootTupleInfo rootTupleInfo;
        ArrayList<RootTupleInfo> retval = new ArrayList<RootTupleInfo>();
        long curTime = System.nanoTime();
        Iterator<RootTupleInfo> iterator = this.inFlightTuples.values().iterator();
        while (iterator.hasNext() && (rootTupleInfo = iterator.next()).isExpired(curTime, timeout.toNanos())) {
            retval.add(rootTupleInfo);
            iterator.remove();
        }
        return retval;
    }

    private List<Integer> admitSpoutTuple(String streamId, List<Object> tuple, Object messageId, Integer emitDirectTaskId) {
        if (this.getPhysicalPlanHelper().isTerminatedComponent()) {
            return null;
        }
        HeronTuples.HeronDataTuple.Builder bldr = this.initTupleBuilder(streamId, tuple, emitDirectTaskId);
        if (messageId != null) {
            RootTupleInfo tupleInfo = new RootTupleInfo(streamId, messageId);
            if (this.ackEnabled) {
                HeronTuples.RootId.Builder rtbldr = this.establishRootId(tupleInfo);
                bldr.addRoots(rtbldr);
            } else {
                this.immediateAcks.offer(tupleInfo);
            }
        }
        this.sendTuple(bldr, streamId, tuple);
        return null;
    }

    private HeronTuples.RootId.Builder establishRootId(RootTupleInfo tupleInfo) {
        long rootId = this.keyGenerator.next();
        HeronTuples.RootId.Builder rtbldr = HeronTuples.RootId.newBuilder();
        rtbldr.setTaskid(this.getPhysicalPlanHelper().getMyTaskId());
        rtbldr.setKey(rootId);
        this.inFlightTuples.put(rootId, tupleInfo);
        return rtbldr;
    }
}

