/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.instance.spout;

public class RootTupleInfo
implements Comparable<RootTupleInfo> {
    private final String streamId;
    private final Object messageId;
    private final long insertionTime;

    public RootTupleInfo(String streamId, Object messageId) {
        this.streamId = streamId;
        this.messageId = messageId;
        this.insertionTime = System.nanoTime();
    }

    public boolean isExpired(long curTime, long timeoutInNs) {
        return this.insertionTime + timeoutInNs - curTime <= 0L;
    }

    public long getInsertionTime() {
        return this.insertionTime;
    }

    public Object getMessageId() {
        return this.messageId;
    }

    public String getStreamId() {
        return this.streamId;
    }

    @Override
    public int compareTo(RootTupleInfo that) {
        if (this.insertionTime - that.getInsertionTime() < 0L) {
            return -1;
        }
        if (this.insertionTime - that.getInsertionTime() > 0L) {
            return 1;
        }
        return 0;
    }
}

