/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.instance.bolt;

import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.heron.api.bolt.IOutputCollector;
import org.apache.heron.api.serializer.IPluggableSerializer;
import org.apache.heron.api.tuple.Tuple;
import org.apache.heron.common.basics.Communicator;
import org.apache.heron.common.utils.metrics.IBoltMetrics;
import org.apache.heron.common.utils.misc.PhysicalPlanHelper;
import org.apache.heron.common.utils.tuple.TupleImpl;
import org.apache.heron.instance.AbstractOutputCollector;
import org.apache.heron.proto.system.HeronTuples;
import org.apache.heron.shaded.com.google.protobuf.Message;

public class BoltOutputCollectorImpl
extends AbstractOutputCollector
implements IOutputCollector {
    private static final Logger LOG = Logger.getLogger(BoltOutputCollectorImpl.class.getName());
    private final IBoltMetrics boltMetrics;

    protected BoltOutputCollectorImpl(IPluggableSerializer serializer, PhysicalPlanHelper helper, Communicator<Message> streamOutQueue, IBoltMetrics boltMetrics) {
        super(serializer, helper, streamOutQueue, boltMetrics);
        this.boltMetrics = boltMetrics;
        if (helper.getMyBolt() == null) {
            throw new RuntimeException(helper.getMyTaskId() + " is not a bolt ");
        }
    }

    @Override
    public List<Integer> emit(String streamId, Collection<Tuple> anchors, List<Object> tuple) {
        return this.admitBoltTuple(streamId, anchors, tuple, null);
    }

    @Override
    public void emitDirect(int taskId, String streamId, Collection<Tuple> anchors, List<Object> tuple) {
        this.admitBoltTuple(streamId, anchors, tuple, taskId);
    }

    @Override
    public void reportError(Throwable error) {
        LOG.log(Level.SEVERE, "Reporting an error in topology code ", error);
    }

    @Override
    public void ack(Tuple input) {
        this.admitAckTuple(input);
    }

    @Override
    public void fail(Tuple input) {
        this.admitFailTuple(input);
    }

    private List<Integer> admitBoltTuple(String streamId, Collection<Tuple> anchors, List<Object> tuple, Integer emitDirectTaskId) {
        if (this.getPhysicalPlanHelper().isTerminatedComponent()) {
            return null;
        }
        HeronTuples.HeronDataTuple.Builder bldr = this.initTupleBuilder(streamId, tuple, emitDirectTaskId);
        if (anchors != null) {
            HashSet<HeronTuples.RootId> mergedRoots = new HashSet<HeronTuples.RootId>();
            for (Tuple tpl : anchors) {
                if (!(tpl instanceof TupleImpl)) continue;
                TupleImpl t = (TupleImpl)tpl;
                mergedRoots.addAll(t.getRoots());
            }
            for (HeronTuples.RootId rt : mergedRoots) {
                bldr.addRoots(rt);
            }
        }
        this.sendTuple(bldr, streamId, tuple);
        return null;
    }

    private void admitAckTuple(Tuple tuple) {
        Duration latency = Duration.ZERO;
        if (this.ackEnabled && tuple instanceof TupleImpl) {
            TupleImpl tuplImpl = (TupleImpl)tuple;
            HeronTuples.AckTuple.Builder bldr = HeronTuples.AckTuple.newBuilder();
            bldr.setAckedtuple(tuplImpl.getTupleKey());
            long tupleSizeInBytes = 0L;
            for (HeronTuples.RootId rt : tuplImpl.getRoots()) {
                bldr.addRoots(rt);
                tupleSizeInBytes += (long)rt.getSerializedSize();
            }
            this.outputter.addAckTuple(bldr, tupleSizeInBytes);
            latency = Duration.ofNanos(System.nanoTime()).minusNanos(tuplImpl.getCreationTime());
        }
        this.getPhysicalPlanHelper().getTopologyContext().invokeHookBoltAck(tuple, latency);
        this.boltMetrics.ackedTuple(tuple.getSourceStreamId(), tuple.getSourceComponent(), latency.toNanos());
    }

    private void admitFailTuple(Tuple tuple) {
        Duration latency = Duration.ZERO;
        if (this.ackEnabled && tuple instanceof TupleImpl) {
            TupleImpl tuplImpl = (TupleImpl)tuple;
            HeronTuples.AckTuple.Builder bldr = HeronTuples.AckTuple.newBuilder();
            bldr.setAckedtuple(tuplImpl.getTupleKey());
            long tupleSizeInBytes = 0L;
            for (HeronTuples.RootId rt : tuplImpl.getRoots()) {
                bldr.addRoots(rt);
                tupleSizeInBytes += (long)rt.getSerializedSize();
            }
            this.outputter.addFailTuple(bldr, tupleSizeInBytes);
            latency = Duration.ofNanos(System.nanoTime()).minusNanos(tuplImpl.getCreationTime());
        }
        this.getPhysicalPlanHelper().getTopologyContext().invokeHookBoltFail(tuple, latency);
        this.boltMetrics.failedTuple(tuple.getSourceStreamId(), tuple.getSourceComponent(), latency.toNanos());
    }
}

