/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.eco.parser;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.heron.eco.definition.BoltDefinition;
import org.apache.heron.eco.definition.EcoTopologyDefinition;
import org.apache.heron.eco.definition.SpoutDefinition;
import org.apache.heron.shaded.org.yaml.snakeyaml.TypeDescription;
import org.apache.heron.shaded.org.yaml.snakeyaml.Yaml;
import org.apache.heron.shaded.org.yaml.snakeyaml.constructor.Constructor;

public class EcoParser {
    private static final Logger LOG = Logger.getLogger(EcoParser.class.getName());

    public EcoTopologyDefinition parseFromInputStream(InputStream inputStream, InputStream propsFile, boolean envFilter) throws Exception {
        Yaml yaml = EcoParser.topologyYaml();
        if (inputStream == null) {
            throw new Exception("Unable to load eco input stream");
        }
        return this.loadTopologyFromYaml(yaml, inputStream, propsFile, envFilter);
    }

    private EcoTopologyDefinition loadTopologyFromYaml(Yaml yaml, InputStream inputStream, InputStream propsIn, boolean envFilter) throws IOException {
        int b;
        LOG.info("Parsing eco config file");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((b = inputStream.read()) != -1) {
            bos.write(b);
        }
        String yamlDefinitionStr = bos.toString();
        if (propsIn != null) {
            LOG.info("Performing property substitution.");
            Properties props = new Properties();
            props.load(propsIn);
            for (Object object : props.keySet()) {
                yamlDefinitionStr = yamlDefinitionStr.replace("${" + object + "}", props.getProperty((String)object));
            }
        } else {
            LOG.info("Not performing property substitution.");
        }
        if (envFilter) {
            LOG.info("Performing environment variable substitution.");
            Map<String, String> envs = System.getenv();
            for (String string : envs.keySet()) {
                yamlDefinitionStr = yamlDefinitionStr.replace("${ENV-" + string + "}", envs.get(string));
            }
        } else {
            LOG.info("Not performing environment variable substitution.");
        }
        return (EcoTopologyDefinition)yaml.load(yamlDefinitionStr);
    }

    private static Yaml topologyYaml() {
        Constructor topologyConstructor = new Constructor(EcoTopologyDefinition.class);
        TypeDescription topologyDescription = new TypeDescription(EcoTopologyDefinition.class);
        topologyDescription.putListPropertyType("spouts", SpoutDefinition.class);
        topologyDescription.putListPropertyType("bolts", BoltDefinition.class);
        topologyConstructor.addTypeDescription(topologyDescription);
        return new Yaml(topologyConstructor);
    }
}

