/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.eco.definition;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.heron.eco.definition.BeanListReference;
import org.apache.heron.eco.definition.BeanReference;
import org.apache.heron.eco.definition.ConfigurationMethodDefinition;
import org.apache.heron.eco.definition.PropertyDefinition;

public class ObjectDefinition {
    private String id;
    private String className;
    private int parallelism = 1;
    private List<Object> constructorArgs;
    private List<PropertyDefinition> properties;
    private List<ConfigurationMethodDefinition> configMethods;
    private boolean hasReferences;

    public List<PropertyDefinition> getProperties() {
        return this.properties;
    }

    public boolean hasConstructorArgs() {
        return this.constructorArgs != null && this.constructorArgs.size() > 0;
    }

    public void setProperties(List<PropertyDefinition> properties) {
        this.properties = properties;
    }

    public boolean hasReferences() {
        return this.hasReferences;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public void setParallelism(int parallelism) {
        this.parallelism = parallelism;
    }

    public List<Object> getConstructorArgs() {
        return this.constructorArgs;
    }

    public void setConstructorArgs(List<Object> constructorArgs) {
        ArrayList<Object> newVal = new ArrayList<Object>();
        for (Object obj : constructorArgs) {
            if (obj instanceof LinkedHashMap) {
                Map map = (Map)obj;
                if (map.containsKey("ref") && map.size() == 1) {
                    newVal.add(new BeanReference((String)map.get("ref")));
                    this.hasReferences = true;
                    continue;
                }
                if (map.containsKey("reflist") && map.size() == 1) {
                    newVal.add(new BeanListReference((List)map.get("reflist")));
                    this.hasReferences = true;
                    continue;
                }
                newVal.add(obj);
                continue;
            }
            newVal.add(obj);
        }
        this.constructorArgs = newVal;
    }

    public List<ConfigurationMethodDefinition> getConfigMethods() {
        return this.configMethods;
    }

    public void setConfigMethods(List<ConfigurationMethodDefinition> configMethods) {
        this.configMethods = configMethods;
    }
}

