/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.eco.definition;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.heron.eco.definition.BeanDefinition;
import org.apache.heron.eco.definition.BoltDefinition;
import org.apache.heron.eco.definition.SpoutDefinition;
import org.apache.heron.eco.definition.StreamDefinition;

public class EcoTopologyDefinition {
    private String name;
    private String type;
    private Map<String, Object> config = new HashMap<String, Object>();
    private Map<String, SpoutDefinition> spouts = new LinkedHashMap<String, SpoutDefinition>();
    private Map<String, BoltDefinition> bolts = new LinkedHashMap<String, BoltDefinition>();
    private List<StreamDefinition> streams = new ArrayList<StreamDefinition>();
    private Map<String, BeanDefinition> components = new LinkedHashMap<String, BeanDefinition>();

    public List<SpoutDefinition> getSpouts() {
        return new ArrayList<SpoutDefinition>(this.spouts.values());
    }

    public SpoutDefinition getSpout(String id) {
        return this.spouts.get(id);
    }

    public void setSpouts(List<SpoutDefinition> sources) {
        this.spouts = new LinkedHashMap<String, SpoutDefinition>();
        for (SpoutDefinition source : sources) {
            this.spouts.put(source.getId(), source);
        }
    }

    public List<BoltDefinition> getBolts() {
        return new ArrayList<BoltDefinition>(this.bolts.values());
    }

    public BoltDefinition getBolt(String id) {
        return this.bolts.get(id);
    }

    public void setBolts(List<BoltDefinition> children) {
        this.bolts = new LinkedHashMap<String, BoltDefinition>();
        for (BoltDefinition child : children) {
            this.bolts.put(child.getId(), child);
        }
    }

    public List<BeanDefinition> getComponents() {
        return new ArrayList<BeanDefinition>(this.components.values());
    }

    public Object getComponent(String id) {
        return this.components.get(id);
    }

    public void setComponents(List<BeanDefinition> components) {
        for (BeanDefinition bean : components) {
            this.components.put(bean.getId(), bean);
        }
    }

    public void addComponent(String key, BeanDefinition value) {
        this.components.put(key, value);
    }

    public List<StreamDefinition> getStreams() {
        return this.streams;
    }

    public void setStreams(List<StreamDefinition> streams) {
        this.streams = streams;
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, Object> config) {
        this.config = config;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        if (this.type == null || "storm".equals(this.type)) {
            return "storm";
        }
        if ("heron".equals(this.type)) {
            return "heron";
        }
        return null;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Number parallelismForBolt(String to) {
        return this.bolts.get(to).getParallelism();
    }
}

