/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.eco.builder.storm;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;
import org.apache.heron.api.Config;
import org.apache.heron.eco.builder.BoltBuilder;
import org.apache.heron.eco.builder.ComponentBuilder;
import org.apache.heron.eco.builder.ConfigBuilder;
import org.apache.heron.eco.builder.ObjectBuilder;
import org.apache.heron.eco.builder.storm.SpoutBuilder;
import org.apache.heron.eco.builder.storm.StreamBuilder;
import org.apache.heron.eco.definition.EcoExecutionContext;
import org.apache.heron.eco.definition.EcoTopologyDefinition;
import org.apache.storm.topology.TopologyBuilder;

public class EcoBuilder {
    private SpoutBuilder spoutBuilder;
    private BoltBuilder boltBuilder;
    private StreamBuilder streamBuilder;
    private ComponentBuilder componentBuilder;
    private ConfigBuilder configBuilder;
    private static final Logger LOG = Logger.getLogger(EcoBuilder.class.getName());

    public EcoBuilder(SpoutBuilder spoutBuilder, BoltBuilder boltBuilder, StreamBuilder streamBuilder, ComponentBuilder componentBuilder, ConfigBuilder configBuilder) {
        this.spoutBuilder = spoutBuilder;
        this.boltBuilder = boltBuilder;
        this.streamBuilder = streamBuilder;
        this.componentBuilder = componentBuilder;
        this.configBuilder = configBuilder;
    }

    public TopologyBuilder buildTopologyBuilder(EcoExecutionContext executionContext, ObjectBuilder objectBuilder) throws InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchFieldException, InvocationTargetException {
        TopologyBuilder builder = new TopologyBuilder();
        LOG.info("Building components");
        this.componentBuilder.buildComponents(executionContext, objectBuilder);
        LOG.info("Building spouts");
        this.spoutBuilder.buildSpouts(executionContext, builder, objectBuilder);
        LOG.info("Building bolts");
        this.boltBuilder.buildBolts(executionContext, objectBuilder);
        LOG.info("Building streams");
        this.streamBuilder.buildStreams(executionContext, builder, objectBuilder);
        return builder;
    }

    public Config buildConfig(EcoTopologyDefinition topologyDefinition) throws Exception {
        LOG.info("Building topology config");
        return this.configBuilder.buildConfig(topologyDefinition);
    }
}

